/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.ShortCollection;
import net.openhft.collect.ShortCursor;
import net.openhft.collect.ShortIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.AbstractShortValueView;
import net.openhft.collect.impl.CommonLongShortMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalLongShortMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.MutableQHashSeparateKVLongShortMapSO;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVLongShortQHash;
import net.openhft.collect.map.LongShortCursor;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.ShortSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.LongShortConsumer;
import net.openhft.function.LongShortPredicate;
import net.openhft.function.LongShortToShortFunction;
import net.openhft.function.LongToShortFunction;
import net.openhft.function.ShortBinaryOperator;
import net.openhft.function.ShortConsumer;
import net.openhft.function.ShortPredicate;

public class MutableQHashSeparateKVLongShortMapGO
extends MutableQHashSeparateKVLongShortMapSO {
    @Override
    final void copy(SeparateKVLongShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVLongShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(long key, short value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public short get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Short getOrDefault(Object key, Short defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public short getOrDefault(long key, short defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Long)key, (Short)vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Long)key, (Short)vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public LongShortCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongShortMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalLongShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalLongShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Long, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                hashCode += (int)(key ^ key >>> 32) ^ vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                hashCode += (int)(key ^ key >>> 32) ^ vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newKeys = this.set;
        int capacity = newKeys.length;
        short[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                int index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] != free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] != free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                int index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] != free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] != free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Short put(Long key, Short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public short put(long key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Short putIfAbsent(Long key, Short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public short putIfAbsent(long key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(long key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Short compute(Long key, BiFunction<? super Long, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int index;
        short[] vals;
        long removed;
        long k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                Short newValue2;
                block29: {
                    if (cur != free) {
                        Short newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply((Long)k, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Long)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Long)k, (Short)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public short compute(long key, LongShortToShortFunction remappingFunction) {
        short newValue;
        int index;
        short[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        short newValue2 = remappingFunction.applyAsShort(key, this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsShort(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(key, vals[index]);
        return newValue;
    }

    @Override
    public Short computeIfAbsent(Long key, Function<? super Long, ? extends Short> mappingFunction) {
        Short value;
        long k;
        block27: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            short[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != free) {
                Short value2;
                int firstRemoved;
                if (cur == k) {
                    return vals[index];
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == free) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == k) {
                                return vals[bIndex];
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == free) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == k) {
                                return vals[fIndex];
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == k) {
                        return vals[bIndex];
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == k) {
                        return vals[fIndex];
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply((Long)k)) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = k;
                    vals[firstRemoved] = value2;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply((Long)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public short computeIfAbsent(long key, LongToShortFunction mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            short[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
            long cur = keys[index];
            if (cur != free) {
                int firstRemoved;
                if (cur == key) {
                    return vals[index];
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == free) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == key) {
                                return vals[bIndex];
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == free) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == key) {
                                return vals[fIndex];
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == key) {
                        return vals[bIndex];
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == key) {
                        return vals[fIndex];
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                short value = mappingFunction.applyAsShort(key);
                this.incrementModCount();
                keys[firstRemoved] = key;
                vals[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        short value = mappingFunction.applyAsShort(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = value;
        this.postFreeSlotInsertHook();
        return value;
    }

    @Override
    public Short computeIfPresent(Long key, BiFunction<? super Long, ? super Short, ? extends Short> remappingFunction) {
        long k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            Short newValue = remappingFunction.apply((Long)k, (Short)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = this.removedValue;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public short computeIfPresent(long key, LongShortToShortFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            short newValue;
            short[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsShort(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Short merge(Long key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int index;
        short[] vals;
        long removed;
        block27: {
            long k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Short)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public short merge(long key, short value, ShortBinaryOperator remappingFunction) {
        short newValue;
        int index;
        short[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(vals[index], value);
        return newValue;
    }

    public short addValue(long key, short value) {
        short newValue;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        short[] vals = this.values;
        vals[index] = newValue = (short)(vals[index] + value);
        return newValue;
    }

    public short addValue(long key, short addition, short defaultValue) {
        short newValue;
        short value = (short)(defaultValue + addition);
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        short[] vals = this.values;
        vals[index] = newValue = (short)(vals[index] + addition);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Long, ? extends Short> m) {
        CommonLongShortMapOps.putAll(this, m);
    }

    @Override
    public Short replace(Long key, Short value) {
        int index = this.index(key);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public short replace(long key, short value) {
        int index = this.index(key);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Long key, Short oldValue, Short newValue) {
        return this.replace((long)key, (short)oldValue, (short)newValue);
    }

    @Override
    public boolean replace(long key, short oldValue, short newValue) {
        int index = this.index(key);
        if (index >= 0) {
            short[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super Short, ? extends Short> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                vals[i] = function.apply((Long)key, (Short)vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.apply((Long)key, (Short)vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(LongShortToShortFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                vals[i] = function.applyAsShort(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.applyAsShort(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    @Override
    public Short remove(Object key) {
        long removed;
        long free;
        long k = (Long)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            short val = this.values[index];
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(long key) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public short remove(long key) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            short val = this.values[index];
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, (Short)value);
    }

    public boolean remove(long key, short value) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if (this.values[index] == value) {
                this.incrementModCount();
                keys[index] = removed;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(LongShortPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements LongShortCursor {
        final long[] keys;
        final short[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements LongShortCursor {
        final long[] keys;
        final short[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ShortCursor {
        final long[] keys;
        final short[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ShortIterator {
        final long[] keys;
        final short[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = this.removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    long removed = this.removed;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Short)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final long[] keys;
        final short[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final long[] keys;
        final short[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Short)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Short>> {
        final long[] keys;
        final short[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Short> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Short>> {
        final long[] keys;
        final short[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = this.removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    long removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Short>> {
        final long[] keys;
        final short[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Short> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Short>> {
        final long[] keys;
        final short[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVLongShortMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVLongShortMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashSeparateKVLongShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return MutableQHashSeparateKVLongShortMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept((Short)vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Short)vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.removeShort(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.removeShort(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ShortCursor cursor() {
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return MutableQHashSeparateKVLongShortMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVLongShortMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test((Short)vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !filter.test((Short)vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(ShortPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.removeAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.retainAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends LongShortEntry {
        private long key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    class MutableEntry
    extends LongShortEntry {
        int modCount;
        private final int index;
        final long key;
        private short value;

        MutableEntry(int modCount, int index, long key, short value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }

        @Override
        public Short setValue(Short newValue) {
            short unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            short oldValue = this.value;
            this.value = unwrappedNewValue = newValue.shortValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(short newValue) {
            MutableQHashSeparateKVLongShortMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class LongShortEntry
    extends AbstractEntry<Long, Short> {
        LongShortEntry() {
        }

        abstract long key();

        @Override
        public final Long getKey() {
            return this.key();
        }

        abstract short value();

        @Override
        public final Short getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Short>>
    implements HashObjSet<Map.Entry<Long, Short>>,
    InternalObjCollectionOps<Map.Entry<Long, Short>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Long, Short>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVLongShortMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVLongShortMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashSeparateKVLongShortMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVLongShortMapGO.this.containsEntry((Long)e.getKey(), (Short)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    action.accept(new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Long, Short>> iterator() {
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Short>> cursor() {
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashSeparateKVLongShortMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVLongShortMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                short value = (Short)e.getValue();
                return MutableQHashSeparateKVLongShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Short>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || !filter.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !filter.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongShortMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongShortMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVLongShortMapGO.this.values;
            if (MutableQHashSeparateKVLongShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVLongShortMapGO.this.clear();
        }
    }
}

