/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.ByteCollection;
import net.openhft.collect.ByteCursor;
import net.openhft.collect.ByteIterator;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractByteValueView;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonIntByteMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalIntByteMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.MutableQHashSeparateKVIntByteMapSO;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVIntByteQHash;
import net.openhft.collect.map.IntByteCursor;
import net.openhft.collect.set.ByteSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.ByteBinaryOperator;
import net.openhft.function.ByteConsumer;
import net.openhft.function.BytePredicate;
import net.openhft.function.IntByteConsumer;
import net.openhft.function.IntBytePredicate;
import net.openhft.function.IntByteToByteFunction;
import net.openhft.function.IntToByteFunction;

public class MutableQHashSeparateKVIntByteMapGO
extends MutableQHashSeparateKVIntByteMapSO {
    @Override
    final void copy(SeparateKVIntByteQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVIntByteQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(int key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public byte get(int key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Byte getOrDefault(Object key, Byte defaultValue) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public byte getOrDefault(int key, byte defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Integer)key, (Byte)vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Integer)key, (Byte)vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(IntByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(IntBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public IntByteCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntByteMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalIntByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalIntByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Integer, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                hashCode += key ^ vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                hashCode += key ^ vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacity = newKeys.length;
        byte[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                int index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] != free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] != free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                int index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] != free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] != free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Byte put(Integer key, Byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public byte put(int key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Byte putIfAbsent(Integer key, Byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public byte putIfAbsent(int key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(int key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Byte compute(Integer key, BiFunction<? super Integer, ? super Byte, ? extends Byte> remappingFunction) {
        Byte newValue;
        int index;
        byte[] vals;
        int removed;
        int k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                Byte newValue2;
                block29: {
                    if (cur != free) {
                        Byte newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply((Integer)k, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Integer)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)k, (Byte)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public byte compute(int key, IntByteToByteFunction remappingFunction) {
        byte newValue;
        int index;
        byte[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        byte newValue2 = remappingFunction.applyAsByte(key, this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsByte(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(key, vals[index]);
        return newValue;
    }

    @Override
    public Byte computeIfAbsent(Integer key, Function<? super Integer, ? extends Byte> mappingFunction) {
        Byte value;
        int k;
        block27: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            byte[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != free) {
                Byte value2;
                int firstRemoved;
                if (cur == k) {
                    return vals[index];
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == free) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == k) {
                                return vals[bIndex];
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == free) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == k) {
                                return vals[fIndex];
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == k) {
                        return vals[bIndex];
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == k) {
                        return vals[fIndex];
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply((Integer)k)) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = k;
                    vals[firstRemoved] = value2;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply((Integer)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public byte computeIfAbsent(int key, IntToByteFunction mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            byte[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
            int cur = keys[index];
            if (cur != free) {
                int firstRemoved;
                if (cur == key) {
                    return vals[index];
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == free) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == key) {
                                return vals[bIndex];
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == free) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == key) {
                                return vals[fIndex];
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == key) {
                        return vals[bIndex];
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == key) {
                        return vals[fIndex];
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                byte value = mappingFunction.applyAsByte(key);
                this.incrementModCount();
                keys[firstRemoved] = key;
                vals[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        byte value = mappingFunction.applyAsByte(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = value;
        this.postFreeSlotInsertHook();
        return value;
    }

    @Override
    public Byte computeIfPresent(Integer key, BiFunction<? super Integer, ? super Byte, ? extends Byte> remappingFunction) {
        int k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            Byte newValue = remappingFunction.apply((Integer)k, (Byte)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = this.removedValue;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public byte computeIfPresent(int key, IntByteToByteFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            byte newValue;
            byte[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsByte(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Byte merge(Integer key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        Byte newValue;
        int index;
        byte[] vals;
        int removed;
        block27: {
            int k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public byte merge(int key, byte value, ByteBinaryOperator remappingFunction) {
        byte newValue;
        int index;
        byte[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(vals[index], value);
        return newValue;
    }

    public byte addValue(int key, byte value) {
        byte newValue;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        byte[] vals = this.values;
        vals[index] = newValue = (byte)(vals[index] + value);
        return newValue;
    }

    public byte addValue(int key, byte addition, byte defaultValue) {
        byte newValue;
        byte value = (byte)(defaultValue + addition);
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        byte[] vals = this.values;
        vals[index] = newValue = (byte)(vals[index] + addition);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Integer, ? extends Byte> m) {
        CommonIntByteMapOps.putAll(this, m);
    }

    @Override
    public Byte replace(Integer key, Byte value) {
        int index = this.index(key);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public byte replace(int key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Integer key, Byte oldValue, Byte newValue) {
        return this.replace((int)key, (byte)oldValue, (byte)newValue);
    }

    @Override
    public boolean replace(int key, byte oldValue, byte newValue) {
        int index = this.index(key);
        if (index >= 0) {
            byte[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super Byte, ? extends Byte> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                vals[i] = function.apply((Integer)key, (Byte)vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.apply((Integer)key, (Byte)vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(IntByteToByteFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                vals[i] = function.applyAsByte(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.applyAsByte(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    @Override
    public Byte remove(Object key) {
        int removed;
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            byte val = this.values[index];
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(int key) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public byte remove(int key) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            byte val = this.values[index];
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, (Byte)value);
    }

    public boolean remove(int key, byte value) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if (this.values[index] == value) {
                this.incrementModCount();
                keys[index] = removed;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(IntBytePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements IntByteCursor {
        final int[] keys;
        final byte[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        byte curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(IntByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements IntByteCursor {
        final int[] keys;
        final byte[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        byte curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(IntByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ByteCursor {
        final int[] keys;
        final byte[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        byte curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ByteIterator {
        final int[] keys;
        final byte[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = this.removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    int removed = this.removed;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Byte)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final int[] keys;
        final byte[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        byte curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final int[] keys;
        final byte[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Byte)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Byte>> {
        final int[] keys;
        final byte[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        byte curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Byte> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Byte>> {
        final int[] keys;
        final byte[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = this.removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Byte> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    int removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Byte>> {
        final int[] keys;
        final byte[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        byte curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Byte> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Byte>> {
        final int[] keys;
        final byte[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Byte> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVIntByteMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVIntByteMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashSeparateKVIntByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return MutableQHashSeparateKVIntByteMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept((Byte)vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Byte)vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.removeByte(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.removeByte(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ByteCursor cursor() {
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return MutableQHashSeparateKVIntByteMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVIntByteMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Byte> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test((Byte)vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !filter.test((Byte)vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(BytePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.removeAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.retainAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends IntByteEntry {
        private int key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    class MutableEntry
    extends IntByteEntry {
        int modCount;
        private final int index;
        final int key;
        private byte value;

        MutableEntry(int modCount, int index, int key, byte value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }

        @Override
        public Byte setValue(Byte newValue) {
            byte unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            byte oldValue = this.value;
            this.value = unwrappedNewValue = newValue.byteValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(byte newValue) {
            MutableQHashSeparateKVIntByteMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class IntByteEntry
    extends AbstractEntry<Integer, Byte> {
        IntByteEntry() {
        }

        abstract int key();

        @Override
        public final Integer getKey() {
            return this.key();
        }

        abstract byte value();

        @Override
        public final Byte getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Byte>>
    implements HashObjSet<Map.Entry<Integer, Byte>>,
    InternalObjCollectionOps<Map.Entry<Integer, Byte>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Integer, Byte>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVIntByteMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVIntByteMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashSeparateKVIntByteMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVIntByteMapGO.this.containsEntry((Integer)e.getKey(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    action.accept(new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Integer, Byte>> iterator() {
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Byte>> cursor() {
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashSeparateKVIntByteMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVIntByteMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                byte value = (Byte)e.getValue();
                return MutableQHashSeparateKVIntByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Byte>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || !filter.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !filter.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntByteMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntByteMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntByteMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVIntByteMapGO.this.values;
            if (MutableQHashSeparateKVIntByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVIntByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVIntByteMapGO.this.clear();
        }
    }
}

