/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.ByteCollection;
import net.openhft.collect.ByteCursor;
import net.openhft.collect.ByteIterator;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractByteValueView;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonDoubleByteMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalDoubleByteMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.MutableQHashSeparateKVDoubleByteMapSO;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVDoubleByteQHash;
import net.openhft.collect.map.DoubleByteCursor;
import net.openhft.collect.set.ByteSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.ByteBinaryOperator;
import net.openhft.function.ByteConsumer;
import net.openhft.function.BytePredicate;
import net.openhft.function.DoubleByteConsumer;
import net.openhft.function.DoubleBytePredicate;
import net.openhft.function.DoubleByteToByteFunction;
import net.openhft.function.DoubleToByteFunction;

public class MutableQHashSeparateKVDoubleByteMapGO
extends MutableQHashSeparateKVDoubleByteMapSO {
    @Override
    final void copy(SeparateKVDoubleByteQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVDoubleByteQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(double key, byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public boolean containsEntry(long key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public byte get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Byte getOrDefault(Object key, Byte defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public byte getOrDefault(double key, byte defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Double, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Double)Double.longBitsToDouble(key), (Byte)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(DoubleByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(DoubleBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public DoubleByteCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleByteMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalDoubleByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalDoubleByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Double, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newKeys = this.set;
        int capacity = newKeys.length;
        byte[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            int index = QHash.SeparateKVDoubleKeyMixing.mix(key) % capacity;
            if (newKeys[index] != 0x7FFFFFFFFFFFFFFEL) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] != 0x7FFFFFFFFFFFFFFEL) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] != 0x7FFFFFFFFFFFFFFEL) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Byte put(Double key, Byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public byte put(double key, byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Byte putIfAbsent(Double key, Byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public byte putIfAbsent(double key, byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(double key, byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public void justPut(long key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Byte compute(Double key, BiFunction<? super Double, ? super Byte, ? extends Byte> remappingFunction) {
        Byte newValue;
        int index;
        byte[] vals;
        long k;
        block25: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                Byte newValue2;
                block26: {
                    if (cur != 0x7FFFFFFFFFFFFFFEL) {
                        Byte newValue3;
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply((Double)Double.longBitsToDouble(k), null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Double)Double.longBitsToDouble(k), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Byte)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return null;
    }

    public byte compute(double key, DoubleByteToByteFunction remappingFunction) {
        byte newValue;
        int index;
        byte[] vals;
        long k;
        block22: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                block23: {
                    if (cur != 0x7FFFFFFFFFFFFFFEL) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        byte newValue2 = remappingFunction.applyAsByte(Double.longBitsToDouble(k), this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsByte(Double.longBitsToDouble(k), this.defaultValue());
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(Double.longBitsToDouble(k), vals[index]);
        return newValue;
    }

    @Override
    public Byte computeIfAbsent(Double key, Function<? super Double, ? extends Byte> mappingFunction) {
        Byte value;
        long k;
        block24: {
            k = Double.doubleToLongBits(key);
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            byte[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != 0x7FFFFFFFFFFFFFFEL) {
                Byte value2;
                int firstRemoved;
                if (cur == k) {
                    return vals[index];
                }
                if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == k) {
                                return vals[bIndex];
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == k) {
                                return vals[fIndex];
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == k) {
                        return vals[bIndex];
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == k) {
                        return vals[fIndex];
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply((Double)Double.longBitsToDouble(k))) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = k;
                    vals[firstRemoved] = value2;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply((Double)Double.longBitsToDouble(k))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public byte computeIfAbsent(double key, DoubleToByteFunction mappingFunction) {
        long k;
        block22: {
            k = Double.doubleToLongBits(key);
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            byte[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != 0x7FFFFFFFFFFFFFFEL) {
                int firstRemoved;
                if (cur == k) {
                    return vals[index];
                }
                if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == k) {
                                return vals[bIndex];
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == k) {
                                return vals[fIndex];
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block22;
                    }
                    if (cur == k) {
                        return vals[bIndex];
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block22;
                    }
                    if (cur == k) {
                        return vals[fIndex];
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                byte value = mappingFunction.applyAsByte(Double.longBitsToDouble(k));
                this.incrementModCount();
                keys[firstRemoved] = k;
                vals[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        byte value = mappingFunction.applyAsByte(Double.longBitsToDouble(k));
        this.incrementModCount();
        keys[index] = k;
        vals[index] = value;
        this.postFreeSlotInsertHook();
        return value;
    }

    @Override
    public Byte computeIfPresent(Double key, BiFunction<? super Double, ? super Byte, ? extends Byte> remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            Byte newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Byte)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = Long.MAX_VALUE;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public byte computeIfPresent(double key, DoubleByteToByteFunction remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            byte newValue;
            byte[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsByte(Double.longBitsToDouble(k), vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Byte merge(Double key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        Byte newValue;
        int index;
        byte[] vals;
        block24: {
            long k = Double.doubleToLongBits(key);
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                block25: {
                    if (cur != 0x7FFFFFFFFFFFFFFEL) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return null;
    }

    public byte merge(double key, byte value, ByteBinaryOperator remappingFunction) {
        byte newValue;
        int index;
        byte[] vals;
        block22: {
            long k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                block23: {
                    if (cur != 0x7FFFFFFFFFFFFFFEL) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(vals[index], value);
        return newValue;
    }

    public byte addValue(double key, byte value) {
        byte newValue;
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return value;
        }
        byte[] vals = this.values;
        vals[index] = newValue = (byte)(vals[index] + value);
        return newValue;
    }

    public byte addValue(double key, byte addition, byte defaultValue) {
        byte newValue;
        byte value;
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value = (byte)(defaultValue + addition));
        if (index < 0) {
            return value;
        }
        byte[] vals = this.values;
        vals[index] = newValue = (byte)(vals[index] + addition);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Double, ? extends Byte> m) {
        CommonDoubleByteMapOps.putAll(this, m);
    }

    @Override
    public Byte replace(Double key, Byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public byte replace(double key, byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Double key, Byte oldValue, Byte newValue) {
        return this.replace((double)key, (byte)oldValue, (byte)newValue);
    }

    @Override
    public boolean replace(double key, byte oldValue, byte newValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Double, ? super Byte, ? extends Byte> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            vals[i] = function.apply((Double)Double.longBitsToDouble(key), (Byte)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(DoubleByteToByteFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            vals[i] = function.applyAsByte(Double.longBitsToDouble(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    @Override
    public Byte remove(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return null;
                }
                step += 2;
            }
        }
        byte val = this.values[index];
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean justRemove(double key) {
        long k = Double.doubleToLongBits(key);
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return true;
    }

    @Override
    public boolean justRemove(long key) {
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(key) % capacity;
        long cur = keys[index];
        if (cur != key) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return true;
    }

    public byte remove(double key) {
        long k = Double.doubleToLongBits(key);
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        byte val = this.values[index];
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, (Byte)value);
    }

    public boolean remove(double key, byte value) {
        long k = Double.doubleToLongBits(key);
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                step += 2;
            }
        }
        if (this.values[index] == value) {
            this.incrementModCount();
            keys[index] = Long.MAX_VALUE;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeIf(DoubleBytePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test(Double.longBitsToDouble(key), vals[i])) continue;
            this.incrementModCount();
            ++mc;
            keys[i] = Long.MAX_VALUE;
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements DoubleByteCursor {
        final long[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements DoubleByteCursor {
        final long[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ByteCursor {
        final long[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public byte elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ByteIterator {
        final long[] keys;
        final byte[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Byte)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
            this.keys[index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final long[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public byte elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final long[] keys;
        final byte[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Byte)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
            this.keys[index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Byte>> {
        final long[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Byte> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Byte>> {
        final long[] keys;
        final byte[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Byte> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
            this.keys[index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Byte>> {
        final long[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Byte> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Byte>> {
        final long[] keys;
        final byte[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Byte> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
            this.keys[index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVDoubleByteMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVDoubleByteMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashSeparateKVDoubleByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return MutableQHashSeparateKVDoubleByteMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Byte)vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeByte(vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVDoubleByteMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ByteCursor cursor() {
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVDoubleByteMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return MutableQHashSeparateKVDoubleByteMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVDoubleByteMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Byte> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !filter.test((Byte)vals[i])) continue;
                MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(BytePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !filter.test(vals[i])) continue;
                MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.removeAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !c.contains(vals[i])) continue;
                MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !c.contains(vals[i])) continue;
                MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.retainAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends DoubleByteEntry {
        private long key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    class MutableEntry
    extends DoubleByteEntry {
        int modCount;
        private final int index;
        final long key;
        private byte value;

        MutableEntry(int modCount, int index, long key, byte value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }

        @Override
        public Byte setValue(Byte newValue) {
            byte unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            byte oldValue = this.value;
            this.value = unwrappedNewValue = newValue.byteValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(byte newValue) {
            MutableQHashSeparateKVDoubleByteMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class DoubleByteEntry
    extends AbstractEntry<Double, Byte> {
        DoubleByteEntry() {
        }

        abstract long key();

        @Override
        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract byte value();

        @Override
        public final Byte getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Byte>>
    implements HashObjSet<Map.Entry<Double, Byte>>,
    InternalObjCollectionOps<Map.Entry<Double, Byte>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Double, Byte>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVDoubleByteMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVDoubleByteMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashSeparateKVDoubleByteMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVDoubleByteMapGO.this.containsEntry((Double)e.getKey(), (byte)((Byte)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Double, Byte>> iterator() {
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVDoubleByteMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Byte>> cursor() {
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVDoubleByteMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashSeparateKVDoubleByteMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVDoubleByteMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                byte value = (Byte)e.getValue();
                return MutableQHashSeparateKVDoubleByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Byte>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !c.contains(e.with(key, vals[i]))) continue;
                MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(e.with(key, vals[i]))) continue;
                MutableQHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVDoubleByteMapGO.this.clear();
        }
    }
}

