/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractObjValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonObjObjMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.InternalObjObjMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.hash.MutableParallelKVObjQHashGO;
import net.openhft.collect.impl.hash.MutableQHashParallelKVObjObjMapSO;
import net.openhft.collect.impl.hash.ObjHash;
import net.openhft.collect.impl.hash.ParallelKVObjObjQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.map.ObjObjCursor;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;

public class MutableQHashParallelKVObjObjMapGO<K, V>
extends MutableQHashParallelKVObjObjMapSO<K, V> {
    final void copy(ParallelKVObjObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVObjObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Equivalence<V> valueEquivalence() {
        return null;
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.nullableValueEquals(this.table[index + 1], value);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.table[index + 1];
        }
        return null;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.table[index + 1];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                action.accept(key, tab[i + 1]);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                action.accept(key, tab[i + 1]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(BiPredicate<? super K, ? super V> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || predicate.test(key, tab[i + 1])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED || predicate.test(key, tab[i + 1])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ObjObjCursor<K, V> cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjObjMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalObjObjMapOps<?, ?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || m.containsEntry(key, tab[i + 1])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED || m.containsEntry(key, tab[i + 1])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalObjObjMapOps<? super K, ? super V> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                m.justPut(key, tab[i + 1]);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                m.justPut(key, tab[i + 1]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<K, V>> entrySet() {
        return new EntryView();
    }

    @Override
    @Nonnull
    public ObjCollection<V> values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                hashCode += this.nullableKeyHashCode(key) ^ this.nullableValueHashCode(tab[i + 1]);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                hashCode += this.nullableKeyHashCode(key) ^ this.nullableValueHashCode(tab[i + 1]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Map)");
                sb.append('=');
                Object val = tab[i + 1];
                sb.append(val != this ? val : "(this Map)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Map)");
                sb.append('=');
                Object val = tab[i + 1];
                sb.append(val != this ? val : "(this Map)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newTab = this.table;
        int capacity = newTab.length;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                int index = QHash.ParallelKVObjKeyMixing.mix(this.nullableKeyHashCode(key)) % capacity;
                if (newTab[index] != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newTab[bIndex] != FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newTab[fIndex] != FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                newTab[index] = key;
                newTab[index + 1] = tab[i + 1];
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                int index = QHash.ParallelKVObjKeyMixing.mix(this.nullableKeyHashCode(key)) % capacity;
                if (newTab[index] != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newTab[bIndex] != FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newTab[fIndex] != FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                newTab[index] = key;
                newTab[index + 1] = tab[i + 1];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public V put(K key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] tab = this.table;
        Object prevValue = tab[index + 1];
        tab[index + 1] = value;
        return (V)prevValue;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.table[index + 1];
    }

    @Override
    public void justPut(K key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        block31: {
            V newValue;
            int index;
            Object[] tab;
            block29: {
                V newValue2;
                block30: {
                    V newValue3;
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    block33: {
                        block32: {
                            if (key == null) break block31;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            tab = this.table;
                            capacity = tab.length;
                            index = QHash.ParallelKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                            cur = tab[index];
                            if (cur == key) break block29;
                            if (cur == FREE) break block30;
                            if (cur == REMOVED) break block32;
                            if (this.keyEquals(key, cur)) break block29;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == key) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == key) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                            break block33;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = tab[bIndex]) == key) {
                            index = bIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = tab[fIndex]) == key) {
                            index = fIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 4;
                    }
                    if ((newValue3 = remappingFunction.apply(key, null)) != null) {
                        this.incrementModCount();
                        tab[firstRemoved] = key;
                        tab[firstRemoved + 1] = newValue3;
                        this.postRemovedSlotInsertHook();
                        return newValue3;
                    }
                    return null;
                }
                if ((newValue2 = remappingFunction.apply(key, null)) != null) {
                    this.incrementModCount();
                    tab[index] = key;
                    tab[index + 1] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
            if ((newValue = remappingFunction.apply(key, tab[index + 1])) != null) {
                tab[index + 1] = newValue;
                return newValue;
            }
            this.incrementModCount();
            tab[index] = REMOVED;
            tab[index + 1] = null;
            this.postRemoveHook();
            return null;
        }
        return this.computeNullKey(remappingFunction);
    }

    V computeNullKey(BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V newValue;
        int index;
        Object[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            int capacity = tab.length;
            index = 0;
            Object cur = tab[0];
            if (cur != null) {
                V newValue2;
                block26: {
                    if (cur != FREE) {
                        V newValue3;
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == null) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == null) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == null) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == null) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 4;
                        }
                        if ((newValue3 = remappingFunction.apply(null, null)) != null) {
                            this.incrementModCount();
                            tab[firstRemoved] = null;
                            tab[firstRemoved + 1] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(null, null)) != null) {
                    this.incrementModCount();
                    tab[index] = null;
                    tab[index + 1] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(null, tab[index + 1])) != null) {
            tab[index + 1] = newValue;
            return newValue;
        }
        this.incrementModCount();
        tab[index] = REMOVED;
        tab[index + 1] = null;
        this.postRemoveHook();
        return null;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        block30: {
            V value;
            block28: {
                Object val;
                int index;
                Object[] tab;
                block29: {
                    V value2;
                    int firstRemoved;
                    int bIndex;
                    Object cur;
                    int capacity;
                    block32: {
                        block31: {
                            if (key == null) break block30;
                            if (mappingFunction == null) {
                                throw new NullPointerException();
                            }
                            tab = this.table;
                            capacity = tab.length;
                            index = QHash.ParallelKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                            cur = tab[index];
                            if (cur == FREE) break block28;
                            if (cur == key) break block29;
                            if (cur == REMOVED) break block31;
                            if (this.keyEquals(key, cur)) break block29;
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == FREE) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == key || this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == FREE) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == key || this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                            break block32;
                        }
                        firstRemoved = index;
                    }
                    bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = tab[bIndex]) == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block28;
                        }
                        if (cur == key) {
                            index = bIndex;
                            break block29;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = tab[fIndex]) == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block28;
                        }
                        if (cur == key) {
                            index = fIndex;
                            break block29;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 4;
                    }
                    if ((value2 = mappingFunction.apply(key)) != null) {
                        this.incrementModCount();
                        tab[firstRemoved] = key;
                        tab[firstRemoved + 1] = value2;
                        this.postRemovedSlotInsertHook();
                        return value2;
                    }
                    return null;
                }
                if ((val = tab[index + 1]) != null) {
                    return (V)val;
                }
                V value3 = mappingFunction.apply(key);
                if (value3 != null) {
                    tab[index + 1] = value3;
                    return value3;
                }
                return null;
            }
            if ((value = mappingFunction.apply(key)) != null) {
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
            return null;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    V computeIfAbsentNullKey(Function<? super K, ? extends V> mappingFunction) {
        V value;
        block26: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] tab = this.table;
            int capacity = tab.length;
            int index = 0;
            Object cur = tab[0];
            if (cur != FREE) {
                Object val;
                block27: {
                    if (cur != null) {
                        V value2;
                        int firstRemoved;
                        int bIndex;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == FREE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (cur == null) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == FREE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (cur == null) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == null) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == null) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 4;
                        }
                        if ((value2 = mappingFunction.apply(null)) != null) {
                            this.incrementModCount();
                            tab[firstRemoved] = null;
                            tab[firstRemoved + 1] = value2;
                            this.postRemovedSlotInsertHook();
                            return value2;
                        }
                        return null;
                    }
                }
                if ((val = tab[index + 1]) != null) {
                    return (V)val;
                }
                V value3 = mappingFunction.apply(null);
                if (value3 != null) {
                    tab[index + 1] = value3;
                    return value3;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply(null)) != null) {
            this.incrementModCount();
            tab[index] = null;
            tab[index + 1] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            Object[] tab = this.table;
            Object val = tab[index + 1];
            if (val != null) {
                V newValue = remappingFunction.apply(key, val);
                if (newValue != null) {
                    tab[index + 1] = newValue;
                    return newValue;
                }
                this.incrementModCount();
                this.table[index] = REMOVED;
                tab[index + 1] = null;
                this.postRemoveHook();
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        block31: {
            Object val;
            int index;
            Object[] tab;
            block29: {
                block30: {
                    int firstRemoved;
                    int bIndex;
                    Object cur;
                    int capacity;
                    block33: {
                        block32: {
                            if (key == null) break block31;
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            tab = this.table;
                            capacity = tab.length;
                            index = QHash.ParallelKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                            cur = tab[index];
                            if (cur == key) break block29;
                            if (cur == FREE) break block30;
                            if (cur == REMOVED) break block32;
                            if (this.keyEquals(key, cur)) break block29;
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == key) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == key) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                            break block33;
                        }
                        firstRemoved = index;
                    }
                    bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = tab[bIndex]) == key) {
                            index = bIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = tab[fIndex]) == key) {
                            index = fIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 4;
                    }
                    this.incrementModCount();
                    tab[firstRemoved] = key;
                    tab[firstRemoved + 1] = value;
                    this.postRemovedSlotInsertHook();
                    return value;
                }
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
            if ((val = tab[index + 1]) != null) {
                V newValue = remappingFunction.apply(val, value);
                if (newValue != null) {
                    tab[index + 1] = newValue;
                    return newValue;
                }
                this.incrementModCount();
                tab[index] = REMOVED;
                tab[index + 1] = null;
                this.postRemoveHook();
                return null;
            }
            tab[index + 1] = value;
            return value;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    V mergeNullKey(V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Object val;
        int index;
        Object[] tab;
        block25: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            int capacity = tab.length;
            index = 0;
            Object cur = tab[0];
            if (cur != null) {
                block26: {
                    if (cur != FREE) {
                        int firstRemoved;
                        int bIndex;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == null) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == null) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == null) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == null) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 4;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = null;
                        tab[firstRemoved + 1] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = null;
                tab[index + 1] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((val = tab[index + 1]) != null) {
            V newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                tab[index + 1] = newValue;
                return newValue;
            }
            this.incrementModCount();
            tab[index] = REMOVED;
            tab[index + 1] = null;
            this.postRemoveHook();
            return null;
        }
        tab[index + 1] = value;
        return value;
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        CommonObjObjMapOps.putAll(this, m);
    }

    @Override
    public V replace(K key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] tab = this.table;
            Object oldValue = tab[index + 1];
            tab[index + 1] = value;
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] tab = this.table;
            if (this.nullableValueEquals(tab[index + 1], oldValue)) {
                tab[index + 1] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                tab[i + 1] = function.apply(key, tab[i + 1]);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                tab[i + 1] = function.apply(key, tab[i + 1]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.table[index + 1] = null;
        this.postRemoveHook();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public V remove(Object key) {
        if (key == null) {
            return this.removeNullKey();
        }
        Object k = key;
        Object[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
        Object cur = tab[index];
        if (cur != k) {
            int bIndex;
            if (cur == FREE) {
                return null;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return null;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return null;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 4;
                        }
                    }
                }
            } else {
                bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = tab[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return null;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = tab[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return null;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 4;
                }
            }
        }
        Object val = tab[index + 1];
        this.incrementModCount();
        tab[index] = REMOVED;
        tab[index + 1] = null;
        this.postRemoveHook();
        return (V)val;
    }

    V removeNullKey() {
        Object[] tab = this.table;
        int capacity = tab.length;
        int index = 0;
        Object cur = tab[0];
        if (cur != null) {
            if (cur == FREE) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 2;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = tab[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = tab[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return null;
                }
                step += 4;
            }
        }
        Object val = tab[index + 1];
        this.incrementModCount();
        tab[index] = REMOVED;
        tab[index + 1] = null;
        this.postRemoveHook();
        return (V)val;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean justRemove(Object key) {
        if (key == null) {
            return this.justRemoveNullKey();
        }
        Object k = key;
        Object[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
        Object cur = tab[index];
        if (cur != k) {
            if (cur == FREE) {
                return false;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 4;
                        }
                    }
                }
            } else {
                int bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = tab[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = tab[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 4;
                }
            }
        }
        this.incrementModCount();
        tab[index] = REMOVED;
        tab[index + 1] = null;
        this.postRemoveHook();
        return true;
    }

    boolean justRemoveNullKey() {
        Object[] tab = this.table;
        int capacity = tab.length;
        int index = 0;
        Object cur = tab[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 2;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = tab[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = tab[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                step += 4;
            }
        }
        this.incrementModCount();
        tab[index] = REMOVED;
        tab[index + 1] = null;
        this.postRemoveHook();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            return this.removeEntryNullKey(value);
        }
        Object k = key;
        Object[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
        Object cur = tab[index];
        if (cur != k) {
            if (cur == FREE) {
                return false;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 4;
                        }
                    }
                }
            } else {
                int bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = tab[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = tab[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 4;
                }
            }
        }
        if (this.nullableValueEquals(tab[index + 1], value)) {
            this.incrementModCount();
            tab[index] = REMOVED;
            tab[index + 1] = null;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    boolean removeEntryNullKey(Object value) {
        Object[] tab = this.table;
        int capacity = tab.length;
        int index = 0;
        Object cur = tab[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 2;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = tab[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = tab[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                step += 4;
            }
        }
        if (this.nullableValueEquals(tab[index + 1], value)) {
            this.incrementModCount();
            tab[index] = REMOVED;
            tab[index + 1] = null;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeIf(BiPredicate<? super K, ? super V> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || !filter.test(key, tab[i + 1])) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                tab[i + 1] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED || !filter.test(key, tab[i + 1])) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                tab[i + 1] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super K> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                tab[i + 1] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                tab[i + 1] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashObjSet<K> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                tab[i + 1] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                tab[i + 1] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashObjSet<K> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                tab[i + 1] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                tab[i + 1] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public ObjIterator<K> iterator() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedKeyIterator(mc);
        }
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public ObjCursor<K> setCursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedKeyCursor(mc);
        }
        return new NoRemovedKeyCursor(mc);
    }

    class SomeRemovedMapCursor
    implements ObjObjCursor<K, V> {
        final Object[] tab;
        int expectedModCount;
        int index;
        Object curKey;
        V curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVObjObjMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(BiConsumer<? super K, ? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(key, tab[i + 1]);
            }
            if (index != this.index || mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.tab[this.index + 1] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                Object[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            int index = this.index;
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements ObjObjCursor<K, V> {
        final Object[] tab;
        int expectedModCount;
        int index;
        Object curKey;
        V curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVObjObjMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(BiConsumer<? super K, ? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, tab[i + 1]);
            }
            if (index != this.index || mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.tab[this.index + 1] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                Object[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            int index = this.index;
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ObjCursor<V> {
        final Object[] tab;
        int expectedModCount;
        int index;
        Object curKey;
        V curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVObjObjMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(tab[i + 1]);
            }
            if (index != this.index || mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public V elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                Object[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            int index = this.index;
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ObjIterator<V> {
        final Object[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        V next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVObjObjMapGO.this.table;
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                Object key = tab[nextI];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                this.next = tab[nextI + 1];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(tab[i + 1]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    this.index = nextI;
                    Object[] tab = this.tab;
                    Object prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        Object key = tab[nextI];
                        if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                        this.next = tab[nextI + 1];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ObjCursor<V> {
        final Object[] tab;
        int expectedModCount;
        int index;
        Object curKey;
        V curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVObjObjMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] == ObjHash.FREE) continue;
                action.accept(tab[i + 1]);
            }
            if (index != this.index || mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public V elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                Object[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            int index = this.index;
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ObjIterator<V> {
        final Object[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        V next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVObjObjMapGO.this.table;
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] == ObjHash.FREE) continue;
                this.next = tab[nextI + 1];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == ObjHash.FREE) continue;
                action.accept(tab[i + 1]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    this.index = nextI;
                    Object[] tab = this.tab;
                    Object prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        if (tab[nextI] == ObjHash.FREE) continue;
                        this.next = tab[nextI + 1];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, V>> {
        final Object[] tab;
        int expectedModCount;
        int index;
        Object curKey;
        V curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVObjObjMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (index != this.index || mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, V> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                Object[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            int index = this.index;
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, V>> {
        final Object[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVObjObjMapGO.this.table;
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                Object key = tab[nextI];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, V> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    this.index = nextI;
                    Object[] tab = this.tab;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        Object key = tab[nextI];
                        if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                        this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, V>> {
        final Object[] tab;
        int expectedModCount;
        int index;
        Object curKey;
        V curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVObjObjMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (index != this.index || mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, V> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                Object[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            int index = this.index;
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, V>> {
        final Object[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVObjObjMapGO.this.table;
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                Object key = tab[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, V> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    this.index = nextI;
                    Object[] tab = this.tab;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        Object key = tab[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractObjValueView<V> {
        ValueView() {
        }

        public Equivalence<V> equivalence() {
            return MutableQHashParallelKVObjObjMapGO.this.valueEquivalence();
        }

        @Override
        public int size() {
            return MutableQHashParallelKVObjObjMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashParallelKVObjObjMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashParallelKVObjObjMapGO.this.containsValue(o);
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == ObjHash.FREE) continue;
                    action.accept(tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept(tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(Predicate<? super V> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == ObjHash.FREE || predicate.test(tab[i + 1])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || predicate.test(tab[i + 1])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == ObjHash.FREE || c.contains(tab[i + 1])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(tab[i + 1])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ObjCollection<? super V> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == ObjHash.FREE) continue;
                    changed |= c.add(tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= c.add(tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == ObjHash.FREE) continue;
                    changed |= s.remove(tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= s.remove(tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        @Nonnull
        public ObjIterator<V> iterator() {
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            if (!MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ObjCursor<V> cursor() {
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            if (!MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == ObjHash.FREE) continue;
                    result[resultIndex++] = tab[i + 1];
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = tab[i + 1];
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == ObjHash.FREE) continue;
                    a[resultIndex++] = tab[i + 1];
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = tab[i + 1];
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object val;
                    if (tab[i] == ObjHash.FREE) continue;
                    sb.append(' ').append((val = tab[i + 1]) != this ? val : "(this Collection)").append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object val;
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    sb.append(' ').append((val = tab[i + 1]) != this ? val : "(this Collection)").append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return MutableQHashParallelKVObjObjMapGO.this.removeValue(o);
        }

        @Override
        public void clear() {
            MutableQHashParallelKVObjObjMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == ObjHash.FREE || !filter.test(tab[i + 1])) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test(tab[i + 1])) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == ObjHash.FREE || !c.contains(tab[i + 1])) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(tab[i + 1])) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == ObjHash.FREE || c.contains(tab[i + 1])) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(tab[i + 1])) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ObjObjEntry {
        private K key;
        private V value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjObjEntry {
        int modCount;
        private final int index;
        final K key;
        private V value;

        MutableEntry(int modCount, int index, K key, V value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            if (this.modCount != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            Object oldValue = this.value;
            Object unwrappedNewValue = newValue;
            this.value = unwrappedNewValue;
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(V newValue) {
            MutableQHashParallelKVObjObjMapGO.this.table[this.index + 1] = newValue;
        }
    }

    abstract class ObjObjEntry
    extends AbstractEntry<K, V> {
        ObjObjEntry() {
        }

        abstract K key();

        @Override
        public final K getKey() {
            return this.key();
        }

        abstract V value();

        @Override
        public final V getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                Object v2 = e2.getValue();
                return MutableQHashParallelKVObjObjMapGO.this.nullableKeyEquals(this.key(), k2) && MutableQHashParallelKVObjObjMapGO.this.nullableValueEquals(this.value(), v2);
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return MutableQHashParallelKVObjObjMapGO.this.nullableKeyHashCode(this.key()) ^ MutableQHashParallelKVObjObjMapGO.this.nullableValueHashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, V>>
    implements HashObjSet<Map.Entry<K, V>>,
    InternalObjCollectionOps<Map.Entry<K, V>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<K, V>> equivalence() {
            return Equivalence.entryEquivalence(MutableQHashParallelKVObjObjMapGO.this.keyEquivalence(), MutableQHashParallelKVObjObjMapGO.this.valueEquivalence());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashParallelKVObjObjMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashParallelKVObjObjMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashParallelKVObjObjMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashParallelKVObjObjMapGO.this.containsEntry(e.getKey(), e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE) continue;
                    action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, V>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || predicate.test(new MutableEntry(mc, i, key, tab[i + 1]))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || predicate.test(new MutableEntry(mc, i, key, tab[i + 1]))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<K, V>> iterator() {
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            if (!MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, V>> cursor() {
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            if (!MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE) continue;
                    changed |= s.remove((Object)e.with(key, tab[i + 1]));
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= s.remove((Object)e.with(key, tab[i + 1]));
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashParallelKVObjObjMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE) continue;
                    sb.append(' ');
                    sb.append(key != this ? key : "(this Collection)");
                    sb.append('=');
                    Object val = tab[i + 1];
                    sb.append(val != this ? val : "(this Collection)");
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    sb.append(' ');
                    sb.append(key != this ? key : "(this Collection)");
                    sb.append('=');
                    Object val = tab[i + 1];
                    sb.append(val != this ? val : "(this Collection)");
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashParallelKVObjObjMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return MutableQHashParallelKVObjObjMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, V>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || !filter.test(new MutableEntry(mc, i, key, tab[i + 1]))) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test(new MutableEntry(mc, i, key, tab[i + 1]))) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || !c.contains(e.with(key, tab[i + 1]))) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(e.with(key, tab[i + 1]))) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVObjObjMapGO.this.modCount();
            Object[] tab = MutableQHashParallelKVObjObjMapGO.this.table;
            if (MutableQHashParallelKVObjObjMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || c.contains(e.with(key, tab[i + 1]))) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(e.with(key, tab[i + 1]))) continue;
                    MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = ObjHash.REMOVED;
                    tab[i + 1] = null;
                    MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashParallelKVObjObjMapGO.this.clear();
        }
    }

    class SomeRemovedKeyCursor
    extends MutableParallelKVObjQHashGO.SomeRemovedCursor {
        private SomeRemovedKeyCursor(int mc) {
            super(mc);
        }

        @Override
        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            int index = this.index;
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedKeyIterator
    extends MutableParallelKVObjQHashGO.SomeRemovedIterator {
        private SomeRemovedKeyIterator(int mc) {
            super(mc);
        }

        @Override
        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedKeyCursor
    extends MutableParallelKVObjQHashGO.NoRemovedCursor {
        private NoRemovedKeyCursor(int mc) {
            super(mc);
        }

        @Override
        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            int index = this.index;
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedKeyIterator
    extends MutableParallelKVObjQHashGO.NoRemovedIterator {
        private NoRemovedKeyIterator(int mc) {
            super(mc);
        }

        @Override
        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVObjObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVObjObjMapGO.this.incrementModCount();
            this.tab[index] = ObjHash.REMOVED;
            this.tab[index + 1] = null;
            MutableQHashParallelKVObjObjMapGO.this.postRemoveHook();
        }
    }
}

