/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import net.openhft.collect.impl.InternalLongDoubleMapOps;
import net.openhft.collect.impl.hash.MutableQHashParallelKVLongKeyMap;
import net.openhft.collect.impl.hash.ParallelKVLongDoubleQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.map.hash.HashLongDoubleMap;

public abstract class MutableQHashParallelKVLongDoubleMapSO
extends MutableQHashParallelKVLongKeyMap
implements HashLongDoubleMap,
InternalLongDoubleMapOps,
ParallelKVLongDoubleQHash {
    int valueIndex(long value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || value != tab[i + 1]) continue;
                index = i;
                break;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || value != tab[i + 1]) continue;
                index = i;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(long value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(long value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(double value) {
        if (this.isEmpty()) {
            return -1;
        }
        long val = Double.doubleToLongBits(value);
        int index = -1;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || val != tab[i + 1]) continue;
                index = i;
                break;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || val != tab[i + 1]) continue;
                index = i;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(double value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(double value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Double)value);
    }

    int insert(long key, long value) {
        block24: {
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVLongKeyMixing.mix(key) % capacity;
            long cur = tab[index];
            if (cur == key) {
                return index;
            }
            if (cur != free) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == key) {
                                return bIndex;
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block24;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == key) {
                                return fIndex;
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block24;
                            }
                            step += 4;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = tab[bIndex]) == key) {
                        return bIndex;
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = tab[fIndex]) == key) {
                        return fIndex;
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 4;
                }
                this.incrementModCount();
                tab[firstRemoved] = key;
                tab[firstRemoved + 1] = value;
                this.postRemovedSlotInsertHook();
                return -1;
            }
        }
        this.incrementModCount();
        tab[index] = key;
        tab[index + 1] = value;
        this.postFreeSlotInsertHook();
        return -1;
    }
}

