/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.FloatCollection;
import net.openhft.collect.FloatCursor;
import net.openhft.collect.FloatIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractFloatValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonIntFloatMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalFloatCollectionOps;
import net.openhft.collect.impl.InternalIntFloatMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.MutableQHashParallelKVIntFloatMapSO;
import net.openhft.collect.impl.hash.ParallelKVIntFloatQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.map.IntFloatCursor;
import net.openhft.collect.set.FloatSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.FloatBinaryOperator;
import net.openhft.function.FloatConsumer;
import net.openhft.function.FloatPredicate;
import net.openhft.function.IntFloatConsumer;
import net.openhft.function.IntFloatPredicate;
import net.openhft.function.IntFloatToFloatFunction;
import net.openhft.function.IntToFloatFunction;

public class MutableQHashParallelKVIntFloatMapGO
extends MutableQHashParallelKVIntFloatMapSO {
    final void copy(ParallelKVIntFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVIntFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    @Override
    public boolean containsEntry(int key, float value) {
        int free = this.freeValue;
        if (key != free && key != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32) == Float.floatToIntBits(value);
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return (int)(entry >>> 32) == Float.floatToIntBits(value);
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return (int)(entry >>> 32) == Float.floatToIntBits(value);
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    @Override
    public boolean containsEntry(int key, int value) {
        int free = this.freeValue;
        if (key != free && key != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return (int)(entry >>> 32) == value;
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return (int)(entry >>> 32) == value;
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue) && k != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == free) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
                if (cur == free) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
                if (cur == free) {
                    return null;
                }
                step += 2;
            }
        }
        return null;
    }

    public float get(int key) {
        int free = this.freeValue;
        if (key != free && key != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == free) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return Float.intBitsToFloat((int)(entry >>> 32));
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return Float.intBitsToFloat((int)(entry >>> 32));
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        return this.defaultValue();
    }

    @Override
    public Float getOrDefault(Object key, Float defaultValue) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue) && k != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public float getOrDefault(int key, float defaultValue) {
        int free = this.freeValue;
        if (key != free && key != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return Float.intBitsToFloat((int)(entry >>> 32));
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return Float.intBitsToFloat((int)(entry >>> 32));
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Integer)key, Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                action.accept((Integer)key, Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(IntFloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(key, Float.intBitsToFloat((int)(entry >>> 32)));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                action.accept(key, Float.intBitsToFloat((int)(entry >>> 32)));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(IntFloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || predicate.test(key, Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed || predicate.test(key, Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public IntFloatCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntFloatMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalIntFloatMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || m.containsEntry(key, (int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed || m.containsEntry(key, (int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalIntFloatMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                m.justPut(key, (int)(entry >>> 32));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                m.justPut(key, (int)(entry >>> 32));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Integer, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                hashCode += key ^ (int)(entry >>> 32);
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                hashCode += key ^ (int)(entry >>> 32);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacity = newTab.length;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
                if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3)) != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)bIndex << 3)) != free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)fIndex << 3)) != free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newTab[index] = entry;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
                if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3)) != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)bIndex << 3)) != free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)fIndex << 3)) != free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newTab[index] = entry;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Float put(Integer key, Float value) {
        long entry;
        int index;
        long[] tab;
        block26: {
            int k = key;
            int removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                this.postFreeSlotInsertHook();
                return null;
            }
            if (cur != k) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        float prevValue = Float.intBitsToFloat((int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value.floatValue()));
        return Float.valueOf(prevValue);
    }

    @Override
    public float put(int key, float value) {
        long entry;
        int index;
        long[] tab;
        block26: {
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postFreeSlotInsertHook();
                return this.defaultValue();
            }
            if (cur != key) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == key) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == key) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        float prevValue = Float.intBitsToFloat((int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value));
        return prevValue;
    }

    @Override
    public Float putIfAbsent(Integer key, Float value) {
        int firstRemoved;
        int k = key;
        int removed = this.removedValue;
        int free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        } else if (k == removed) {
            removed = this.changeRemoved();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
            this.postFreeSlotInsertHook();
            return null;
        }
        if (cur == k) {
            return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
        }
        if (cur != removed) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == free) {
                        this.incrementModCount();
                        tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == free) {
                        this.incrementModCount();
                        tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    @Override
    public float putIfAbsent(int key, float value) {
        int firstRemoved;
        int removed = this.removedValue;
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        } else if (key == removed) {
            removed = this.changeRemoved();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
            this.postFreeSlotInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return Float.intBitsToFloat((int)(entry >>> 32));
        }
        if (cur != removed) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == free) {
                        this.incrementModCount();
                        tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        return Float.intBitsToFloat((int)(entry >>> 32));
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == free) {
                        this.incrementModCount();
                        tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        return Float.intBitsToFloat((int)(entry >>> 32));
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    @Override
    public void justPut(int key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value));
    }

    @Override
    public void justPut(int key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), value);
    }

    @Override
    public Float compute(Integer key, BiFunction<? super Integer, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        long entry;
        int index;
        long[] tab;
        int removed;
        int k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                Float newValue2;
                block29: {
                    if (cur != free) {
                        Float newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply((Integer)k, null)) != null) {
                            this.incrementModCount();
                            tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue3.floatValue()) << 32;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Integer)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue2.floatValue()) << 32;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)k, Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) != null) {
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue.floatValue()));
            return newValue;
        }
        this.incrementModCount();
        U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3), removed);
        this.postRemoveHook();
        return null;
    }

    public float compute(int key, IntFloatToFloatFunction remappingFunction) {
        long entry;
        int index;
        long[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        float newValue = remappingFunction.applyAsFloat(key, this.defaultValue());
                        this.incrementModCount();
                        tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue) << 32;
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                float newValue = remappingFunction.applyAsFloat(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue) << 32;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        float newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat((int)(entry >>> 32)));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    @Override
    public Float computeIfAbsent(Integer key, Function<? super Integer, ? extends Float> mappingFunction) {
        Float value;
        int k;
        block27: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != free) {
                Float value2;
                int firstRemoved;
                if (cur == k) {
                    return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == free) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == k) {
                                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == free) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == k) {
                                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == k) {
                        return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == k) {
                        return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply((Integer)k)) != null) {
                    this.incrementModCount();
                    tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value2.floatValue()) << 32;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply((Integer)k)) != null) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public float computeIfAbsent(int key, IntToFloatFunction mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != free) {
                int firstRemoved;
                if (cur == key) {
                    return Float.intBitsToFloat((int)(entry >>> 32));
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == free) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == key) {
                                return Float.intBitsToFloat((int)(entry >>> 32));
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == free) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == key) {
                                return Float.intBitsToFloat((int)(entry >>> 32));
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == key) {
                        return Float.intBitsToFloat((int)(entry >>> 32));
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == key) {
                        return Float.intBitsToFloat((int)(entry >>> 32));
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                float value = mappingFunction.applyAsFloat(key);
                this.incrementModCount();
                tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        float value = mappingFunction.applyAsFloat(key);
        this.incrementModCount();
        tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
        this.postFreeSlotInsertHook();
        return value;
    }

    @Override
    public Float computeIfPresent(Integer key, BiFunction<? super Integer, ? super Float, ? extends Float> remappingFunction) {
        int removed;
        int k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (k != free && k != (removed = this.removedValue)) {
            Float newValue;
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            if ((newValue = remappingFunction.apply((Integer)k, Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) != null) {
                U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue.floatValue()));
                return newValue;
            }
            this.incrementModCount();
            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3), removed);
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public float computeIfPresent(int key, IntFloatToFloatFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (key != free && key != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            float newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat((int)(entry >>> 32)));
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Float merge(Integer key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        long entry;
        int index;
        long[] tab;
        int removed;
        block27: {
            int k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))), value)) != null) {
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue.floatValue()));
            return newValue;
        }
        this.incrementModCount();
        U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3), removed);
        this.postRemoveHook();
        return null;
    }

    public float merge(int key, float value, FloatBinaryOperator remappingFunction) {
        long entry;
        int index;
        long[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        float newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat((int)(entry >>> 32)), value);
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    public float addValue(int key, float value) {
        long entry;
        int index;
        long[] tab;
        block26: {
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postFreeSlotInsertHook();
                return value;
            }
            if (cur != key) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                                this.postFreeSlotInsertHook();
                                return value;
                            }
                            if (cur == key) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                                this.postFreeSlotInsertHook();
                                return value;
                            }
                            if (cur == key) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                            this.postFreeSlotInsertHook();
                            return value;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                    if (cur == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                            this.postFreeSlotInsertHook();
                            return value;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                    if (cur == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        float newValue = Float.intBitsToFloat((int)(entry >>> 32)) + value;
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    public float addValue(int key, float addition, float defaultValue) {
        long entry;
        int index;
        long[] tab;
        block26: {
            float value = defaultValue + addition;
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postFreeSlotInsertHook();
                return value;
            }
            if (cur != key) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                                this.postFreeSlotInsertHook();
                                return value;
                            }
                            if (cur == key) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                                this.postFreeSlotInsertHook();
                                return value;
                            }
                            if (cur == key) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                            this.postFreeSlotInsertHook();
                            return value;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                    if (cur == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                            this.postFreeSlotInsertHook();
                            return value;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                    if (cur == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        float newValue = Float.intBitsToFloat((int)(entry >>> 32)) + addition;
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Integer, ? extends Float> m) {
        CommonIntFloatMapOps.putAll(this, m);
    }

    @Override
    public Float replace(Integer key, Float value) {
        int free;
        int k = key;
        if (k != (free = this.freeValue) && k != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            float oldValue = Float.intBitsToFloat((int)(entry >>> 32));
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value.floatValue()));
            return Float.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public float replace(int key, float value) {
        int free = this.freeValue;
        if (key != free && key != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            float oldValue = Float.intBitsToFloat((int)(entry >>> 32));
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value));
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Integer key, Float oldValue, Float newValue) {
        return this.replace((int)key, oldValue.floatValue(), newValue.floatValue());
    }

    @Override
    public boolean replace(int key, float oldValue, float newValue) {
        int free = this.freeValue;
        if (key != free && key != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((int)(entry >>> 32) == Float.floatToIntBits(oldValue)) {
                U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super Float, ? extends Float> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)i << 3), Float.floatToIntBits(function.apply((Integer)key, Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)))).floatValue()));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)i << 3), Float.floatToIntBits(function.apply((Integer)key, Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)))).floatValue()));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(IntFloatToFloatFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)i << 3), Float.floatToIntBits(function.applyAsFloat(key, Float.intBitsToFloat((int)(entry >>> 32)))));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)i << 3), Float.floatToIntBits(function.applyAsFloat(key, Float.intBitsToFloat((int)(entry >>> 32)))));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    @Override
    public Float remove(Object key) {
        int removed;
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            float val = Float.intBitsToFloat((int)(entry >>> 32));
            this.incrementModCount();
            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3), removed);
            this.postRemoveHook();
            return Float.valueOf(val);
        }
        return null;
    }

    @Override
    public boolean justRemove(int key) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3), removed);
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public float remove(int key) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            float val = Float.intBitsToFloat((int)(entry >>> 32));
            this.incrementModCount();
            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3), removed);
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, ((Float)value).floatValue());
    }

    public boolean remove(int key, float value) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((int)(entry >>> 32) == Float.floatToIntBits(value)) {
                this.incrementModCount();
                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3), removed);
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(IntFloatPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || !filter.test(key, Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed || !filter.test(key, Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements IntFloatCursor {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            int free = this.free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(IntFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                action.accept(key, Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_VALUE_OFFSET + ((long)this.index << 3), Float.floatToIntBits(value));
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)this.index << 3), this.removed);
            MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements IntFloatCursor {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            int free = this.free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(IntFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(key, Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_VALUE_OFFSET + ((long)this.index << 3), Float.floatToIntBits(value));
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)this.index << 3), this.removed);
            MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements FloatCursor {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            int free = this.free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public float elem() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)this.index << 3), this.removed);
            MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements FloatIterator {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        float next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            int free = this.free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = this.removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                this.next = Float.intBitsToFloat((int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    int free = this.free;
                    int removed = this.removed;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key == free || key == removed) continue;
                        this.next = Float.intBitsToFloat((int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)index << 3), this.removed);
            MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            int free = this.free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public float elem() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)this.index << 3), this.removed);
            MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        float next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            int free = this.free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry == free) continue;
                this.next = Float.intBitsToFloat((int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    int free = this.free;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        if ((int)entry == free) continue;
                        this.next = Float.intBitsToFloat((int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)index << 3), this.removed);
            MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Float>> {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            int free = this.free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (index != this.index || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Float> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)this.index << 3), this.removed);
            MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Float>> {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            int free = this.free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = this.removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    int free = this.free;
                    int removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)index << 3), this.removed);
            MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Float>> {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            int free = this.free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (index != this.index || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Float> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)this.index << 3), this.removed);
            MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Float>> {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            int free = this.free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    int free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)index << 3), this.removed);
            MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableQHashParallelKVIntFloatMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashParallelKVIntFloatMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashParallelKVIntFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return MutableQHashParallelKVIntFloatMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(int bits) {
            return MutableQHashParallelKVIntFloatMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free) continue;
                    action.accept(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    action.accept(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free) continue;
                    action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free || predicate.test(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || predicate.test(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free || c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free || c.contains((int)(entry >>> 32))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || c.contains((int)(entry >>> 32))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free) continue;
                    changed |= c.add(Float.intBitsToFloat((int)(entry >>> 32)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    changed |= c.add(Float.intBitsToFloat((int)(entry >>> 32)));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free) continue;
                    changed |= c.add((int)(entry >>> 32));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    changed |= c.add((int)(entry >>> 32));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free) continue;
                    changed |= s.removeFloat(Float.intBitsToFloat((int)(entry >>> 32)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    changed |= s.removeFloat(Float.intBitsToFloat((int)(entry >>> 32)));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free) continue;
                    changed |= s.removeFloat((int)(entry >>> 32));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    changed |= s.removeFloat((int)(entry >>> 32));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            if (!MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public FloatCursor cursor() {
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            if (!MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free) continue;
                    result[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free) continue;
                    a[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free) continue;
                    result[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free) continue;
                    a[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free) continue;
                    sb.append(' ').append(Float.intBitsToFloat((int)(entry >>> 32))).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    sb.append(' ').append(Float.intBitsToFloat((int)(entry >>> 32))).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return MutableQHashParallelKVIntFloatMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeFloat(int bits) {
            return MutableQHashParallelKVIntFloatMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            MutableQHashParallelKVIntFloatMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free || !filter.test(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || !filter.test(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(FloatPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free || !filter.test(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || !filter.test(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof FloatCollection) {
                return this.removeAll((FloatCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free || !c.contains(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || !c.contains(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.removeAll((InternalFloatCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free || !c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || !c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalFloatCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free || !c.contains((int)(entry >>> 32))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || !c.contains((int)(entry >>> 32))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof FloatCollection) {
                return this.retainAll((FloatCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free || c.contains(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || c.contains(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.retainAll((InternalFloatCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free || c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalFloatCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    if ((int)entry == free || c.contains((int)(entry >>> 32))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || c.contains((int)(entry >>> 32))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends IntFloatEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends IntFloatEntry {
        int modCount;
        private final int index;
        final int key;
        private int value;

        MutableEntry(int modCount, int index, int key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public Float setValue(Float newValue) {
            int unwrappedNewValue;
            if (this.modCount != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            float oldValue = Float.intBitsToFloat(this.value);
            this.value = unwrappedNewValue = Float.floatToIntBits(newValue.floatValue());
            this.updateValueInTable(unwrappedNewValue);
            return Float.valueOf(oldValue);
        }

        void updateValueInTable(int newValue) {
            UnsafeConstants.U.putFloat(MutableQHashParallelKVIntFloatMapGO.this.table, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_VALUE_OFFSET + ((long)this.index << 3), newValue);
        }
    }

    abstract class IntFloatEntry
    extends AbstractEntry<Integer, Float> {
        IntFloatEntry() {
        }

        abstract int key();

        @Override
        public final Integer getKey() {
            return this.key();
        }

        abstract int value();

        @Override
        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Float>>
    implements HashObjSet<Map.Entry<Integer, Float>>,
    InternalObjCollectionOps<Map.Entry<Integer, Float>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Integer, Float>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashParallelKVIntFloatMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashParallelKVIntFloatMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashParallelKVIntFloatMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashParallelKVIntFloatMapGO.this.containsEntry((int)((Integer)e.getKey()), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || predicate.test(new MutableEntry(mc, i, key, (int)(entry >>> 32)))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || predicate.test(new MutableEntry(mc, i, key, (int)(entry >>> 32)))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Integer, Float>> iterator() {
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            if (!MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Float>> cursor() {
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            if (!MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashParallelKVIntFloatMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashParallelKVIntFloatMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                float value = ((Float)e.getValue()).floatValue();
                return MutableQHashParallelKVIntFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Float>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || !filter.test(new MutableEntry(mc, i, key, (int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || !filter.test(new MutableEntry(mc, i, key, (int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || !c.contains(e.with(key, (int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || !c.contains(e.with(key, (int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = MutableQHashParallelKVIntFloatMapGO.this.freeValue;
            int removed = MutableQHashParallelKVIntFloatMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVIntFloatMapGO.this.table;
            if (MutableQHashParallelKVIntFloatMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || c.contains(e.with(key, (int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed || c.contains(e.with(key, (int)(entry >>> 32)))) continue;
                    MutableQHashParallelKVIntFloatMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), removed);
                    MutableQHashParallelKVIntFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashParallelKVIntFloatMapGO.this.clear();
        }
    }
}

