/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.ShortCollection;
import net.openhft.collect.ShortCursor;
import net.openhft.collect.impl.CommonSetOps;
import net.openhft.collect.impl.CommonShortCollectionOps;
import net.openhft.collect.impl.InternalShortCollectionOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableShortLHashSetSO;
import net.openhft.collect.impl.hash.SeparateKVShortLHash;
import net.openhft.collect.set.ShortSet;
import net.openhft.collect.set.hash.HashShortSet;

public class MutableLHashShortSetGO
extends MutableShortLHashSetSO
implements HashShortSet,
InternalShortCollectionOps {
    @Override
    final void copy(SeparateKVShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonShortCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public ShortCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Short e) {
        return this.add((short)e);
    }

    public boolean add(short key) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        short[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVShortKeyMixing.mix(key) & capacityMask;
        short cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != free) {
                if (cur != key) continue;
                return false;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Short> c) {
        return CommonShortCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        return this.removeShort((Short)key);
    }

    @Override
    boolean justRemove(short key) {
        return this.removeShort(key);
    }

    public boolean removeShort(short key) {
        short free = this.freeValue;
        if (key != free) {
            short keyToShift;
            int indexToRemove;
            short[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVShortKeyMixing.mix(key) & capacityMask;
            short cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        if (c instanceof ShortCollection) {
            InternalShortCollectionOps c2;
            if (c instanceof InternalShortCollectionOps && (c2 = (InternalShortCollectionOps)((Object)c)).size() < this.size()) {
                return c2.reverseRemoveAllFrom((ShortSet)this);
            }
            return this.removeAll((HashShortSet)this, (ShortCollection)c);
        }
        return this.removeAll((HashShortSet)this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

