/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalObjDoubleMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableLHashSeparateKVObjKeyMap;
import net.openhft.collect.impl.hash.SeparateKVObjDoubleLHash;
import net.openhft.collect.map.hash.HashObjDoubleMap;

public abstract class MutableLHashSeparateKVObjDoubleMapSO<K>
extends MutableLHashSeparateKVObjKeyMap<K>
implements HashObjDoubleMap<K>,
InternalObjDoubleMapOps<K>,
SeparateKVObjDoubleLHash {
    long[] values;

    void copy(SeparateKVObjDoubleLHash hash) {
        super.copy(hash);
        this.values = (long[])hash.valueArray().clone();
    }

    void move(SeparateKVObjDoubleLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public long[] valueArray() {
        return this.values;
    }

    int valueIndex(long value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == FREE || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(long value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(long value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(double value) {
        if (this.isEmpty()) {
            return -1;
        }
        long val = Double.doubleToLongBits(value);
        int index = -1;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == FREE || val != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(double value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(double value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Double)value);
    }

    int insert(K key, long value) {
        if (key != null) {
            block5: {
                Object[] keys = this.set;
                int capacityMask = keys.length - 1;
                int index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) & capacityMask;
                Object cur = keys[index];
                if (cur == key) {
                    return index;
                }
                if (cur != FREE) {
                    do {
                        if ((cur = keys[index = index - 1 & capacityMask]) == key) {
                            return index;
                        }
                        if (cur == FREE) break block5;
                    } while (!this.keyEquals(key, cur));
                    return index;
                }
            }
            this.incrementModCount();
            keys[index] = key;
            this.values[index] = value;
            this.postInsertHook();
            return -1;
        }
        return this.insertNullKey(value);
    }

    int insertNullKey(long value) {
        Object[] keys = this.set;
        int index = 0;
        Object cur = keys[0];
        if (cur == null) {
            return index;
        }
        if (cur != FREE) {
            int capacityMask = keys.length - 1;
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != null) continue;
                return index;
            } while (cur != FREE);
        }
        this.incrementModCount();
        keys[index] = null;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new long[capacity];
    }
}

