/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalDoubleIntMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableLHashSeparateKVDoubleKeyMap;
import net.openhft.collect.impl.hash.SeparateKVDoubleIntLHash;
import net.openhft.collect.map.hash.HashDoubleIntMap;

public abstract class MutableLHashSeparateKVDoubleIntMapSO
extends MutableLHashSeparateKVDoubleKeyMap
implements HashDoubleIntMap,
InternalDoubleIntMapOps,
SeparateKVDoubleIntLHash {
    int[] values;

    void copy(SeparateKVDoubleIntLHash hash) {
        super.copy(hash);
        this.values = (int[])hash.valueArray().clone();
    }

    void move(SeparateKVDoubleIntLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public int[] valueArray() {
        return this.values;
    }

    int valueIndex(int value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(int value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(int value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Integer)value);
    }

    int insert(long key, int value) {
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix(key) & capacityMask;
        long cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != 0x7FFFFFFFFFFFFFFEL);
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new int[capacity];
    }
}

