/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.LongCollection;
import net.openhft.collect.LongCursor;
import net.openhft.collect.LongIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractLongValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonLongLongMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalLongLongMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableLHashParallelKVLongLongMapSO;
import net.openhft.collect.impl.hash.MutableParallelKVLongLHashGO;
import net.openhft.collect.impl.hash.ParallelKVLongLongLHash;
import net.openhft.collect.map.LongLongCursor;
import net.openhft.collect.set.LongSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashLongSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.LongLongConsumer;
import net.openhft.function.LongLongPredicate;
import net.openhft.function.LongLongToLongFunction;

public class MutableLHashParallelKVLongLongMapGO
extends MutableLHashParallelKVLongLongMapSO {
    final void copy(ParallelKVLongLongLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVLongLongLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public long defaultValue() {
        return 0L;
    }

    @Override
    public boolean containsEntry(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return null;
    }

    public long get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return this.defaultValue();
    }

    @Override
    public Long getOrDefault(Object key, Long defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return defaultValue;
    }

    public long getOrDefault(long key, long defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            action.accept((Long)key, (Long)tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongLongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            action.accept(key, tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongLongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free || predicate.test(key, tab[i + 1])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public LongLongCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongLongMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalLongLongMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free || m.containsEntry(key, tab[i + 1])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalLongLongMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            m.justPut(key, tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Long, Long>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public LongCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            long val = tab[i + 1];
            hashCode += (int)(key ^ key >>> 32) ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(tab[i + 1]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacityMask = newTab.length - 2;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            int index = LHash.ParallelKVLongKeyMixing.mix(key) & capacityMask;
            if (newTab[index] != free) {
                while (newTab[index = index - 2 & capacityMask] == free) {
                }
            }
            newTab[index] = key;
            newTab[index + 1] = tab[i + 1];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Long put(Long key, Long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        long[] tab = this.table;
        long prevValue = tab[index + 1];
        tab[index + 1] = value;
        return prevValue;
    }

    @Override
    public long put(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        long[] tab = this.table;
        long prevValue = tab[index + 1];
        tab[index + 1] = value;
        return prevValue;
    }

    @Override
    public Long putIfAbsent(Long key, Long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return this.table[index + 1];
    }

    @Override
    public long putIfAbsent(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.table[index + 1];
    }

    @Override
    public void justPut(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Long compute(Long key, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVLongKeyMixing.mix(k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl15
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                if ((newValue = remappingFunction.apply((Long)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = k;
                    tab[index + 1] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Long)k, (Long)tab[index + 1])) != null) {
            tab[index + 1] = newValue;
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public long compute(long key, LongLongToLongFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVLongKeyMixing.mix(key) & capacityMask;
            cur = tab[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl14
            while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                if (cur != free) continue;
lbl14:
                // 2 sources

                newValue = remappingFunction.applyAsLong(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        tab[index + 1] = newValue = remappingFunction.applyAsLong(key, tab[index + 1]);
        return newValue;
    }

    @Override
    public Long computeIfAbsent(Long key, Function<? super Long, ? extends Long> mappingFunction) {
        Long value;
        long k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVLongKeyMixing.mix(k) & capacityMask;
        long cur = tab[index];
        if (cur != free) {
            if (cur == k) {
                return tab[index + 1];
            }
            while ((cur = tab[index = index - 2 & capacityMask]) != free) {
                if (cur != k) continue;
                return tab[index + 1];
            }
        }
        if ((value = mappingFunction.apply((Long)k)) != null) {
            this.incrementModCount();
            tab[index] = k;
            tab[index + 1] = value;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public long computeIfAbsent(long key, LongUnaryOperator mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVLongKeyMixing.mix(key) & capacityMask;
        long cur = tab[index];
        if (cur != free) {
            if (cur == key) {
                return tab[index + 1];
            }
            while ((cur = tab[index = index - 2 & capacityMask]) != free) {
                if (cur != key) continue;
                return tab[index + 1];
            }
        }
        long value = mappingFunction.applyAsLong(key);
        this.incrementModCount();
        tab[index] = key;
        tab[index + 1] = value;
        this.postInsertHook();
        return value;
    }

    @Override
    public Long computeIfPresent(Long key, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        long k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            Long newValue = remappingFunction.apply((Long)k, (Long)tab[index + 1]);
            if (newValue != null) {
                tab[index + 1] = newValue;
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public long computeIfPresent(long key, LongLongToLongFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long newValue;
            long[] tab = this.table;
            tab[index + 1] = newValue = remappingFunction.applyAsLong(key, tab[index + 1]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Long merge(Long key, Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        block5: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVLongKeyMixing.mix(k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl17
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != free) continue;
lbl17:
                // 2 sources

                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Long)tab[index + 1], value)) != null) {
            tab[index + 1] = newValue;
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public long merge(long key, long value, LongBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVLongKeyMixing.mix(key) & capacityMask;
            cur = tab[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl14
            while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                if (cur != free) continue;
lbl14:
                // 2 sources

                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = value;
                this.postInsertHook();
                return value;
            }
        }
        tab[index + 1] = newValue = remappingFunction.applyAsLong(tab[index + 1], value);
        return newValue;
    }

    public long addValue(long key, long value) {
        long newValue;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        long[] tab = this.table;
        tab[index + 1] = newValue = tab[index + 1] + value;
        return newValue;
    }

    public long addValue(long key, long addition, long defaultValue) {
        long newValue;
        long value = defaultValue + addition;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        long[] tab = this.table;
        tab[index + 1] = newValue = tab[index + 1] + addition;
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Long, ? extends Long> m) {
        CommonLongLongMapOps.putAll(this, m);
    }

    @Override
    public Long replace(Long key, Long value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            long oldValue = tab[index + 1];
            tab[index + 1] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public long replace(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            long oldValue = tab[index + 1];
            tab[index + 1] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Long key, Long oldValue, Long newValue) {
        return this.replace((long)key, (long)oldValue, (long)newValue);
    }

    @Override
    public boolean replace(long key, long oldValue, long newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            if (tab[index + 1] == oldValue) {
                tab[index + 1] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super Long, ? extends Long> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            tab[i + 1] = function.apply((Long)key, (Long)tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(LongLongToLongFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            tab[i + 1] = function.applyAsLong(key, tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        long keyToShift;
        int indexToRemove;
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 2;
        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
            if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = keyToShift;
                tab[indexToRemove + 1] = tab[indexToShift + 1];
                indexToRemove = indexToShift;
                shiftDistance = 2;
                continue;
            }
            shiftDistance += 2;
            if (indexToShift != 2 + index) continue;
            throw new ConcurrentModificationException();
        }
        tab[indexToRemove] = free;
        this.postRemoveHook();
    }

    @Override
    public Long remove(Object key) {
        long free;
        long k = (Long)key;
        if (k != (free = this.freeValue)) {
            long keyToShift;
            int indexToRemove;
            long[] tab = this.table;
            int capacityMask = tab.length - 2;
            int index = LHash.ParallelKVLongKeyMixing.mix(k) & capacityMask;
            long cur = tab[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            long val = tab[index + 1];
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = keyToShift;
                    tab[indexToRemove + 1] = tab[indexToShift + 1];
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
                if (indexToShift != 2 + index) continue;
                throw new ConcurrentModificationException();
            }
            tab[indexToRemove] = free;
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(long key) {
        long free = this.freeValue;
        if (key != free) {
            long keyToShift;
            int indexToRemove;
            long[] tab = this.table;
            int capacityMask = tab.length - 2;
            int index = LHash.ParallelKVLongKeyMixing.mix(key) & capacityMask;
            long cur = tab[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = keyToShift;
                    tab[indexToRemove + 1] = tab[indexToShift + 1];
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
                if (indexToShift != 2 + index) continue;
                throw new ConcurrentModificationException();
            }
            tab[indexToRemove] = free;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public long remove(long key) {
        long free = this.freeValue;
        if (key != free) {
            long keyToShift;
            int indexToRemove;
            long[] tab = this.table;
            int capacityMask = tab.length - 2;
            int index = LHash.ParallelKVLongKeyMixing.mix(key) & capacityMask;
            long cur = tab[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            long val = tab[index + 1];
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = keyToShift;
                    tab[indexToRemove + 1] = tab[indexToShift + 1];
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
                if (indexToShift != 2 + index) continue;
                throw new ConcurrentModificationException();
            }
            tab[indexToRemove] = free;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, (Long)value);
    }

    public boolean remove(long key, long value) {
        long free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 2;
            int index = LHash.ParallelKVLongKeyMixing.mix(key) & capacityMask;
            long cur = tab[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if (tab[index + 1] == value) {
                long keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = free;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(LongLongPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !filter.test(key, tab[i + 1])) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = tab[indexToRemove];
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Long> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !filter.test((Long)key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = tab[indexToRemove];
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(LongPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = tab[indexToRemove];
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = tab[indexToRemove];
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = tab[indexToRemove];
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.retainAll(thisC, (LongCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block13: {
                long key = tab[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = tab[indexToRemove];
                                break block13;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block12: {
                long key = tab[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = tab[indexToRemove];
                                break block12;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved, long delayedRemoved) {
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        for (int i = firstDelayedRemoved; i >= 0; i -= 2) {
            long keyToShift;
            int indexToRemove;
            if (tab[i] != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                if (keyToShift != delayedRemoved && (LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = keyToShift;
                    tab[indexToRemove + 1] = tab[indexToShift + 1];
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
                if (indexToShift != 2 + i) continue;
                throw new ConcurrentModificationException();
            }
            tab[indexToRemove] = free;
        }
    }

    @Override
    public LongIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public LongCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements LongLongCursor {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVLongLongMapGO.this.table;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVLongLongMapGO.this.freeValue);
        }

        public void forEachForward(LongLongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(key, tab[i + 1]);
            }
            if (index != this.index || mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(long value) {
            if (this.curKey == this.free) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashParallelKVLongLongMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.tab[this.index + 1] = value;
            if (this.tab == MutableLHashParallelKVLongLongMapGO.this.table) return;
            MutableLHashParallelKVLongLongMapGO.this.table[this.index + 1] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongLongMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongLongMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        tab[indexToRemove] = free;
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = free;
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongLongMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements LongCursor {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVLongLongMapGO.this.table;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVLongLongMapGO.this.freeValue);
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(tab[i + 1]);
            }
            if (index != this.index || mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongLongMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongLongMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        tab[indexToRemove] = free;
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = free;
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongLongMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements LongIterator {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        long next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVLongLongMapGO.this.table;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            this.capacityMask = tab.length - 2;
            long free = this.free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] == free) continue;
                this.next = tab[nextI + 1];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    long free = this.free;
                    long prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        if (tab[nextI] == free) continue;
                        this.next = tab[nextI + 1];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept((Long)tab[i + 1]);
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(tab[i + 1]);
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongLongMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongLongMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != this.free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        tab[indexToRemove] = this.free;
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = tab[indexToShift + 1];
                                }
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = this.free;
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongLongMapGO.this.justRemove(tab[index]);
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Long>> {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVLongLongMapGO.this.table;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVLongLongMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(new MutableEntry2(mc, i, key, tab[i + 1]));
            }
            if (index != this.index || mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Long> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongLongMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongLongMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        tab[indexToRemove] = free;
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = free;
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongLongMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, long key, long value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(long newValue) {
                if (NoRemovedEntryCursor.this.tab == MutableLHashParallelKVLongLongMapGO.this.table) {
                    NoRemovedEntryCursor.this.tab[NoRemovedEntryCursor.this.index + 1] = newValue;
                } else {
                    MutableLHashParallelKVLongLongMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Long>> {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVLongLongMapGO.this.table;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            this.capacityMask = tab.length - 2;
            long free = this.free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key == free) continue;
                this.next = new MutableEntry2(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(new MutableEntry2(mc, i, key, tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    long free = this.free;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry2(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongLongMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongLongMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != this.free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        tab[indexToRemove] = this.free;
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = new MutableEntry2(MutableLHashParallelKVLongLongMapGO.this.modCount(), indexToShift, keyToShift, tab[indexToShift + 1]);
                                }
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = this.free;
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongLongMapGO.this.justRemove(tab[index]);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, long key, long value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(long newValue) {
                if (NoRemovedEntryIterator.this.tab == MutableLHashParallelKVLongLongMapGO.this.table) {
                    NoRemovedEntryIterator.this.tab[NoRemovedEntryIterator.this.index + 1] = newValue;
                } else {
                    MutableLHashParallelKVLongLongMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractLongValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableLHashParallelKVLongLongMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashParallelKVLongLongMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableLHashParallelKVLongLongMapGO.this.containsValue(o);
        }

        public boolean contains(long v) {
            return MutableLHashParallelKVLongLongMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept((Long)tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(LongPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || predicate.test(tab[i + 1])) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(LongCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || c.contains(tab[i + 1])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(LongCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= c.add(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(LongSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= s.removeLong(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public LongIterator iterator() {
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public LongCursor cursor() {
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                result[resultIndex++] = tab[i + 1];
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public long[] toLongArray() {
            int size = this.size();
            long[] result = new long[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                result[resultIndex++] = tab[i + 1];
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public long[] toArray(long[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new long[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0L;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0L;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                sb.append(' ').append(tab[i + 1]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeLong((Long)o);
        }

        public boolean removeLong(long v) {
            return MutableLHashParallelKVLongLongMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableLHashParallelKVLongLongMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    if (tab[i] == free || !filter.test((Long)tab[i + 1])) continue;
                    MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = tab[indexToRemove];
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongLongMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(LongPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    if (tab[i] == free || !filter.test(tab[i + 1])) continue;
                    MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = tab[indexToRemove];
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongLongMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof LongCollection) {
                return this.removeAll((LongCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    if (tab[i] == free || !c.contains(tab[i + 1])) continue;
                    MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = tab[indexToRemove];
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongLongMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(LongCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    if (tab[i] == free || !c.contains(tab[i + 1])) continue;
                    MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = tab[indexToRemove];
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongLongMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof LongCollection) {
                return this.retainAll((LongCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block13: {
                    if (tab[i] == free || c.contains(tab[i + 1])) continue;
                    MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = tab[indexToRemove];
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongLongMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(LongCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    if (tab[i] == free || c.contains(tab[i + 1])) continue;
                    MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = tab[indexToRemove];
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongLongMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends LongLongEntry {
        private long key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends LongLongEntry {
        int modCount;
        private final int index;
        final long key;
        private long value;

        MutableEntry(int modCount, int index, long key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Long setValue(Long newValue) {
            long unwrappedNewValue;
            if (this.modCount != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            long oldValue = this.value;
            this.value = unwrappedNewValue = newValue.longValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            MutableLHashParallelKVLongLongMapGO.this.table[this.index + 1] = newValue;
        }
    }

    abstract class LongLongEntry
    extends AbstractEntry<Long, Long> {
        LongLongEntry() {
        }

        abstract long key();

        @Override
        public final Long getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Long getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                long v2 = (Long)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Long>>
    implements HashObjSet<Map.Entry<Long, Long>>,
    InternalObjCollectionOps<Map.Entry<Long, Long>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Long, Long>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashParallelKVLongLongMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableLHashParallelKVLongLongMapGO.this.size();
        }

        public double currentLoad() {
            return MutableLHashParallelKVLongLongMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashParallelKVLongLongMapGO.this.containsEntry((Long)e.getKey(), (Long)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Long>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || predicate.test(new MutableEntry(mc, i, key, tab[i + 1]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Long, Long>> iterator() {
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Long>> cursor() {
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Long>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableLHashParallelKVLongLongMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(tab[i + 1]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashParallelKVLongLongMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                long value = (Long)e.getValue();
                return MutableLHashParallelKVLongLongMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Long>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    long key = tab[i];
                    if (key == free || !filter.test(new MutableEntry(mc, i, key, tab[i + 1]))) continue;
                    MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = tab[indexToRemove];
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongLongMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block13: {
                    long key = tab[i];
                    if (key == free || !c.contains(e.with(key, tab[i + 1]))) continue;
                    MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = tab[indexToRemove];
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongLongMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVLongLongMapGO.this.modCount();
            long free = MutableLHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongLongMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    long key = tab[i];
                    if (key == free || c.contains(e.with(key, tab[i + 1]))) continue;
                    MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = tab[indexToRemove];
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongLongMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableLHashParallelKVLongLongMapGO.this.clear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableParallelKVLongLHashGO.NoRemovedCursor {
        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashParallelKVLongLongMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongLongMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongLongMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        tab[indexToRemove] = free;
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = free;
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongLongMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableParallelKVLongLHashGO.NoRemovedIterator {
        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashParallelKVLongLongMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongLongMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongLongMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongLongMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != this.free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        tab[indexToRemove] = this.free;
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = this.free;
                MutableLHashParallelKVLongLongMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongLongMapGO.this.justRemove(tab[index]);
            }
        }
    }
}

