/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.LHashShortSetFactoryGO;
import net.openhft.collect.impl.hash.QHashShortSetFactoryImpl;
import net.openhft.collect.set.hash.HashShortSetFactory;

public final class LHashShortSetFactoryImpl
extends LHashShortSetFactoryGO {
    public LHashShortSetFactoryImpl() {
        this(HashConfig.getDefault(), 10, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public LHashShortSetFactoryImpl(HashConfig hashConf, int defaultExpectedSize, short lower, short upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    HashShortSetFactory thisWith(HashConfig hashConf, int defaultExpectedSize, short lower, short upper) {
        return new LHashShortSetFactoryImpl(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    HashShortSetFactory qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, short lower, short upper) {
        return new QHashShortSetFactoryImpl(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    HashShortSetFactory lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, short lower, short upper) {
        return new LHashShortSetFactoryImpl(hashConf, defaultExpectedSize, lower, upper);
    }

    HashShortSetFactory withDomain(short lower, short upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return new LHashShortSetFactoryImpl(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public HashShortSetFactory withKeysDomain(short lower, short upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public HashShortSetFactory withKeysDomainComplement(short lower, short upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain((short)(upper + 1), (short)(lower - 1));
    }
}

