/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.hash.ImmutableLHashObjSet;
import net.openhft.collect.impl.hash.ImmutableLHashObjSetGO;
import net.openhft.collect.impl.hash.MutableLHashObjSet;
import net.openhft.collect.impl.hash.MutableLHashObjSetGO;
import net.openhft.collect.impl.hash.ObjHashFactorySO;
import net.openhft.collect.impl.hash.SeparateKVObjLHash;
import net.openhft.collect.impl.hash.UpdatableLHashObjSet;
import net.openhft.collect.impl.hash.UpdatableLHashObjSetGO;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.collect.set.hash.HashObjSetFactory;

public abstract class LHashObjSetFactorySO<E>
extends ObjHashFactorySO<E>
implements HashObjSetFactory<E> {
    LHashObjSetFactorySO(HashConfig hashConf, int defaultExpectedSize, boolean isNullAllowed) {
        super(hashConf, defaultExpectedSize, isNullAllowed);
    }

    String keySpecialString() {
        return ",equivalence=" + this.getEquivalence() + ",nullKeyAllowed=" + this.isNullKeyAllowed();
    }

    boolean keySpecialEquals(HashObjSetFactory<?> other) {
        return NullableObjects.equals(this.getEquivalence(), other.getEquivalence()) && this.isNullKeyAllowed() == other.isNullKeyAllowed();
    }

    @Override
    @Nullable
    public Equivalence<E> getEquivalence() {
        return null;
    }

    <E2 extends E> MutableLHashObjSetGO<E2> uninitializedMutableSet() {
        return new MutableLHashObjSet();
    }

    <E2 extends E> UpdatableLHashObjSetGO<E2> uninitializedUpdatableSet() {
        return new UpdatableLHashObjSet();
    }

    <E2 extends E> ImmutableLHashObjSetGO<E2> uninitializedImmutableSet() {
        return new ImmutableLHashObjSet();
    }

    public <E2 extends E> MutableLHashObjSetGO<E2> newMutableSet(int expectedSize) {
        MutableLHashObjSetGO<E2> set = this.uninitializedMutableSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(int expectedSize) {
        UpdatableLHashObjSetGO<E2> set = this.uninitializedUpdatableSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elements, int expectedSize) {
        if (elements instanceof ObjCollection) {
            int size;
            if (elements instanceof ObjSet) {
                SeparateKVObjLHash hash;
                ObjSet elemSet = (ObjSet)elements;
                if (elements instanceof SeparateKVObjLHash && (hash = (SeparateKVObjLHash)((Object)elements)).hashConfig().equals(this.hashConf) && NullableObjects.equals(elemSet.equivalence(), this.getEquivalence())) {
                    UpdatableLHashObjSetGO<E2> set = this.uninitializedUpdatableSet();
                    set.copy(hash);
                    return set;
                }
                size = NullableObjects.equals(elemSet.equivalence(), this.getEquivalence()) ? elemSet.size() : expectedSize;
            } else {
                size = expectedSize;
            }
            HashObjSet set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = this.getEquivalence() == null && elements instanceof Set ? ((Set)elements).size() : expectedSize;
        HashObjSet set = this.newUpdatableSet(size);
        for (E2 e : elements) {
            set.add(e);
        }
        return set;
    }
}

