/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.FloatCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.FloatLHashFactory;
import net.openhft.collect.impl.hash.ImmutableLHashFloatSet;
import net.openhft.collect.impl.hash.ImmutableLHashFloatSetGO;
import net.openhft.collect.impl.hash.MutableLHashFloatSet;
import net.openhft.collect.impl.hash.MutableLHashFloatSetGO;
import net.openhft.collect.impl.hash.SeparateKVFloatLHash;
import net.openhft.collect.impl.hash.UpdatableLHashFloatSet;
import net.openhft.collect.impl.hash.UpdatableLHashFloatSetGO;
import net.openhft.collect.set.hash.HashFloatSetFactory;

public abstract class LHashFloatSetFactorySO
extends FloatLHashFactory
implements HashFloatSetFactory {
    LHashFloatSetFactorySO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    MutableLHashFloatSetGO uninitializedMutableSet() {
        return new MutableLHashFloatSet();
    }

    UpdatableLHashFloatSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashFloatSet();
    }

    ImmutableLHashFloatSetGO uninitializedImmutableSet() {
        return new ImmutableLHashFloatSet();
    }

    public MutableLHashFloatSetGO newMutableSet(int expectedSize) {
        MutableLHashFloatSet set = new MutableLHashFloatSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    public UpdatableLHashFloatSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashFloatSet set = new UpdatableLHashFloatSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    public UpdatableLHashFloatSetGO newUpdatableSet(Iterable<Float> elements, int expectedSize) {
        if (elements instanceof FloatCollection) {
            SeparateKVFloatLHash hash;
            if (elements instanceof SeparateKVFloatLHash && (hash = (SeparateKVFloatLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashFloatSet set = new UpdatableLHashFloatSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashFloatSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashFloatSetGO set = this.newUpdatableSet(size);
        for (float e : elements) {
            set.add(e);
        }
        return set;
    }
}

