/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.FloatCollection;
import net.openhft.collect.FloatCursor;
import net.openhft.collect.FloatIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractFloatValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonLongFloatMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalFloatCollectionOps;
import net.openhft.collect.impl.InternalLongFloatMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableQHashSeparateKVLongFloatMapSO;
import net.openhft.collect.impl.hash.SeparateKVLongFloatQHash;
import net.openhft.collect.map.LongFloatCursor;
import net.openhft.collect.set.FloatSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.FloatBinaryOperator;
import net.openhft.function.FloatConsumer;
import net.openhft.function.FloatPredicate;
import net.openhft.function.LongFloatConsumer;
import net.openhft.function.LongFloatPredicate;
import net.openhft.function.LongFloatToFloatFunction;
import net.openhft.function.LongToFloatFunction;

public class ImmutableQHashSeparateKVLongFloatMapGO
extends ImmutableQHashSeparateKVLongFloatMapSO {
    @Override
    final void copy(SeparateKVLongFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVLongFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    @Override
    public boolean containsEntry(long key, float value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Float.floatToIntBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(long key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return null;
    }

    public float get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return this.defaultValue();
    }

    @Override
    public Float getOrDefault(Object key, Float defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return defaultValue;
    }

    public float getOrDefault(long key, float defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept((Long)key, Float.valueOf(Float.intBitsToFloat(vals[i])));
        }
    }

    public void forEach(LongFloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept(key, Float.intBitsToFloat(vals[i]));
        }
    }

    public boolean forEachWhile(LongFloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || predicate.test(key, Float.intBitsToFloat(vals[i]))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public LongFloatCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongFloatMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalLongFloatMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalLongFloatMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Long, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Float.intBitsToFloat(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Float put(Long key, Float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float put(long key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float putIfAbsent(Long key, Float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float putIfAbsent(long key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(long key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(long key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float compute(Long key, BiFunction<? super Long, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float compute(long key, LongFloatToFloatFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float computeIfAbsent(Long key, Function<? super Long, ? extends Float> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float computeIfAbsent(long key, LongToFloatFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float computeIfPresent(Long key, BiFunction<? super Long, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float computeIfPresent(long key, LongFloatToFloatFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float merge(Long key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float merge(long key, float value, FloatBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float addValue(long key, float value) {
        throw new UnsupportedOperationException();
    }

    public float addValue(long key, float addition, float defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Long, ? extends Float> m) {
        CommonLongFloatMapOps.putAll(this, m);
    }

    @Override
    public Float replace(Long key, Float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float replace(long key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Long key, Float oldValue, Float newValue) {
        return this.replace((long)key, oldValue.floatValue(), newValue.floatValue());
    }

    @Override
    public boolean replace(long key, float oldValue, float newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super Float, ? extends Float> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(LongFloatToFloatFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public float remove(long key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, ((Float)value).floatValue());
    }

    public boolean remove(long key, float value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(LongFloatPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements LongFloatCursor {
        final long[] keys;
        final int[] vals;
        final long free;
        int index;
        long curKey;
        int curValue;

        NoRemovedMapCursor() {
            long free;
            this.keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue);
        }

        public void forEachForward(LongFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Float.floatToIntBits(value);
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            long free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        final long[] keys;
        final int[] vals;
        final long free;
        int index;
        long curKey;
        int curValue;

        NoRemovedValueCursor() {
            long free;
            this.keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue);
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public float elem() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            long free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        final long[] keys;
        final int[] vals;
        final long free;
        int nextIndex;
        float next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            long free = this.free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = Float.intBitsToFloat(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                long free = this.free;
                float prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = Float.intBitsToFloat(this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Float>> {
        final long[] keys;
        final int[] vals;
        final long free;
        int index;
        long curKey;
        int curValue;

        NoRemovedEntryCursor() {
            long free;
            this.keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Float> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            long free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Float>> {
        final long[] keys;
        final int[] vals;
        final long free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            long free = this.free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                long free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    long key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(int bits) {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(Float.intBitsToFloat(vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(Float.intBitsToFloat(vals[i]));
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeFloat(Float.intBitsToFloat(vals[i]));
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeFloat(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public FloatCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(Float.intBitsToFloat(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeFloat(int bits) {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVLongFloatMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(FloatPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends LongFloatEntry {
        private long key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends LongFloatEntry {
        private final long key;
        private final int value;

        ImmutableEntry(long key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class LongFloatEntry
    extends AbstractEntry<Long, Float> {
        LongFloatEntry() {
        }

        abstract long key();

        @Override
        public final Long getKey() {
            return this.key();
        }

        abstract int value();

        @Override
        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Float>>
    implements HashObjSet<Map.Entry<Long, Float>>,
    InternalObjCollectionOps<Map.Entry<Long, Float>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Long, Float>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVLongFloatMapGO.this.containsEntry((long)((Long)e.getKey()), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || predicate.test(new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Long, Float>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Float>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long free = ImmutableQHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Float.intBitsToFloat(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVLongFloatMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                float value = ((Float)e.getValue()).floatValue();
                return ImmutableQHashSeparateKVLongFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Float>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVLongFloatMapGO.this.clear();
        }
    }
}

