/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.collect.CharCollection;
import net.openhft.collect.CharCursor;
import net.openhft.collect.CharIterator;
import net.openhft.collect.impl.hash.ImmutableParallelKVCharLHashSO;
import net.openhft.collect.set.CharSet;
import net.openhft.collect.set.hash.HashCharSet;
import net.openhft.function.CharConsumer;
import net.openhft.function.CharPredicate;

public abstract class ImmutableParallelKVCharLHashGO
extends ImmutableParallelKVCharLHashSO {
    @Override
    @Nonnull
    public int[] table() {
        return this.table;
    }

    @Override
    public int capacity() {
        return this.table.length;
    }

    public void forEach(Consumer<? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            action.accept(Character.valueOf(key));
        }
    }

    public void forEach(CharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            action.accept(key);
        }
    }

    public boolean forEachWhile(CharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    public boolean allContainingIn(CharCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(CharCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            changed |= c.add(key);
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(CharSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            changed |= s.removeChar(key);
        }
        return changed;
    }

    public CharIterator iterator() {
        return new NoRemovedIterator();
    }

    public CharCursor setCursor() {
        return new NoRemovedCursor();
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = Character.valueOf(key);
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = Character.valueOf(key);
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public char[] toCharArray() {
        int size = this.size();
        char[] result = new char[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        return result;
    }

    @Nonnull
    public char[] toArray(char[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new char[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = '\u0000';
            }
            return a;
        }
        int resultIndex = 0;
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (a.length > resultIndex) {
            a[resultIndex] = '\u0000';
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            hashCode += key;
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            sb.append(' ').append(key).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(char var1);

    public boolean removeIf(Predicate<? super Character> filter) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(CharPredicate filter) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        throw new UnsupportedOperationException();
    }

    boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.retainAll(thisC, (CharCollection)c);
        }
        throw new UnsupportedOperationException();
    }

    private boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedCursor
    implements CharCursor {
        final int[] tab;
        final char free;
        int index;
        char curKey;

        NoRemovedCursor() {
            char free;
            this.tab = ImmutableParallelKVCharLHashGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableParallelKVCharLHashGO.this.freeValue);
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] tab = this.tab;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedIterator
    implements CharIterator {
        final int[] tab;
        final char free;
        int nextIndex;
        char next;

        NoRemovedIterator() {
            this.tab = ImmutableParallelKVCharLHashGO.this.table;
            int[] tab = ImmutableParallelKVCharLHashGO.this.table;
            char free = this.free = ImmutableParallelKVCharLHashGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] tab = this.tab;
                char free = this.free;
                char prev = this.next;
                while (--nextI >= 0) {
                    int entry = tab[nextI];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.next = key;
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(Character.valueOf(key));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

