/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.hash.HashConfigWrapper;

abstract class AbstractHashFactory {
    final HashConfig hashConf;
    final HashConfigWrapper configWrapper;
    final int defaultExpectedSize;

    AbstractHashFactory(HashConfig hashConf, int defaultExpectedSize) {
        this.hashConf = hashConf;
        this.configWrapper = new HashConfigWrapper(hashConf);
        this.defaultExpectedSize = defaultExpectedSize;
    }

    @Nonnull
    public final HashConfig getHashConfig() {
        return this.hashConf;
    }

    public final int getDefaultExpectedSize() {
        return this.defaultExpectedSize;
    }

    String commonString() {
        return "hashConfig=" + this.getHashConfig() + ",defaultExpectedSize=" + this.getDefaultExpectedSize();
    }

    boolean commonEquals(HashContainerFactory<?> other) {
        return this.getHashConfig().equals(other.getHashConfig()) && this.getDefaultExpectedSize() == other.getDefaultExpectedSize();
    }

    int commonHashCode() {
        int hashCode = 17;
        hashCode = hashCode * 31 + this.getHashConfig().hashCode();
        return hashCode * 31 + this.getDefaultExpectedSize();
    }
}

