/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalObjShortMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.map.ObjShortMap;
import net.openhft.function.ObjShortConsumer;
import net.openhft.function.ObjShortPredicate;

public final class CommonObjShortMapOps {
    public static boolean containsAllEntries(final InternalObjShortMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ObjShortMap) {
            ObjShortMap m2 = (ObjShortMap)another;
            if (NullableObjects.equals(m2.keyEquivalence(), map.keyEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalObjShortMapOps) {
                    return ((InternalObjShortMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ObjShortPredicate(){

                public boolean test(Object a, short b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(e.getKey(), (Short)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <K> void putAll(final InternalObjShortMapOps<K> map, Map<? extends K, ? extends Short> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjShortMap) {
            if (another instanceof InternalObjShortMapOps) {
                ((InternalObjShortMapOps)another).reversePutAllTo(map);
            } else {
                ((ObjShortMap)another).forEach(new ObjShortConsumer<K>(){

                    public void accept(K key, short value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, Short> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonObjShortMapOps() {
    }
}

