/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalLongIntMapOps;
import net.openhft.collect.map.LongIntMap;
import net.openhft.function.LongIntConsumer;
import net.openhft.function.LongIntPredicate;

public final class CommonLongIntMapOps {
    public static boolean containsAllEntries(final InternalLongIntMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof LongIntMap) {
            LongIntMap m2 = (LongIntMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalLongIntMapOps) {
                return ((InternalLongIntMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new LongIntPredicate(){

                public boolean test(long a, int b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Long)e.getKey(), (Integer)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalLongIntMapOps map, Map<? extends Long, ? extends Integer> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof LongIntMap) {
            if (another instanceof InternalLongIntMapOps) {
                ((InternalLongIntMapOps)another).reversePutAllTo(map);
            } else {
                ((LongIntMap)another).forEach(new LongIntConsumer(){

                    public void accept(long key, int value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Long, ? extends Integer> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonLongIntMapOps() {
    }
}

