/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Collection;
import net.openhft.collect.FloatCollection;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalFloatCollectionOps;
import net.openhft.collect.set.FloatSet;
import net.openhft.function.FloatConsumer;
import net.openhft.function.FloatPredicate;

public final class CommonFloatCollectionOps {
    public static boolean containsAll(final FloatCollection collection, Collection<?> another) {
        if (collection == another) {
            return true;
        }
        if (another instanceof FloatCollection) {
            FloatCollection c2 = (FloatCollection)another;
            if (collection instanceof FloatSet && c2 instanceof FloatSet && collection.size() < another.size()) {
                return false;
            }
            if (c2 instanceof InternalFloatCollectionOps) {
                return ((InternalFloatCollectionOps)c2).allContainingIn(collection);
            }
            return c2.forEachWhile(new FloatPredicate(){

                public boolean test(float value) {
                    return collection.contains(value);
                }
            });
        }
        for (Object o : another) {
            if (collection.contains(((Float)o).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean addAll(FloatCollection collection, Collection<? extends Float> another) {
        if (collection == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = collection.sizeAsLong() + Containers.sizeAsLong(another);
        collection.ensureCapacity(maxPossibleSize);
        if (another instanceof FloatCollection) {
            if (another instanceof InternalFloatCollectionOps) {
                return ((InternalFloatCollectionOps)((Object)another)).reverseAddAllTo(collection);
            }
            class AddAll
            implements FloatConsumer {
                boolean collectionChanged = false;
                final /* synthetic */ FloatCollection val$collection;

                AddAll(FloatCollection floatCollection) {
                    this.val$collection = floatCollection;
                }

                public void accept(float value) {
                    this.collectionChanged |= this.val$collection.add(value);
                }
            }
            AddAll addAll = new AddAll(collection);
            ((FloatCollection)another).forEach((FloatConsumer)addAll);
            return addAll.collectionChanged;
        }
        boolean collectionChanged = false;
        for (Float f : another) {
            collectionChanged |= collection.add(f.floatValue());
        }
        return collectionChanged;
    }

    private CommonFloatCollectionOps() {
    }
}

