/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalDoubleLongMapOps;
import net.openhft.collect.map.DoubleLongMap;
import net.openhft.function.DoubleLongConsumer;
import net.openhft.function.DoubleLongPredicate;

public final class CommonDoubleLongMapOps {
    public static boolean containsAllEntries(final InternalDoubleLongMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof DoubleLongMap) {
            DoubleLongMap m2 = (DoubleLongMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalDoubleLongMapOps) {
                return ((InternalDoubleLongMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new DoubleLongPredicate(){

                public boolean test(double a, long b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Double)e.getKey(), (long)((Long)e.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalDoubleLongMapOps map, Map<? extends Double, ? extends Long> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof DoubleLongMap) {
            if (another instanceof InternalDoubleLongMapOps) {
                ((InternalDoubleLongMapOps)another).reversePutAllTo(map);
            } else {
                ((DoubleLongMap)another).forEach(new DoubleLongConsumer(){

                    public void accept(double key, long value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Double, ? extends Long> e : another.entrySet()) {
                map.justPut(e.getKey(), (long)e.getValue());
            }
        }
    }

    private CommonDoubleLongMapOps() {
    }
}

