/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalCharByteMapOps;
import net.openhft.collect.map.CharByteMap;
import net.openhft.function.CharByteConsumer;
import net.openhft.function.CharBytePredicate;

public final class CommonCharByteMapOps {
    public static boolean containsAllEntries(final InternalCharByteMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof CharByteMap) {
            CharByteMap m2 = (CharByteMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalCharByteMapOps) {
                return ((InternalCharByteMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new CharBytePredicate(){

                public boolean test(char a, byte b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Character)e.getKey()).charValue(), (Byte)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalCharByteMapOps map, Map<? extends Character, ? extends Byte> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof CharByteMap) {
            if (another instanceof InternalCharByteMapOps) {
                ((InternalCharByteMapOps)another).reversePutAllTo(map);
            } else {
                ((CharByteMap)another).forEach(new CharByteConsumer(){

                    public void accept(char key, byte value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Character, ? extends Byte> e : another.entrySet()) {
                map.justPut(e.getKey().charValue(), e.getValue());
            }
        }
    }

    private CommonCharByteMapOps() {
    }
}

