/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Collection;
import net.openhft.collect.ByteCollection;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalByteCollectionOps;
import net.openhft.collect.set.ByteSet;
import net.openhft.function.ByteConsumer;
import net.openhft.function.BytePredicate;

public final class CommonByteCollectionOps {
    public static boolean containsAll(final ByteCollection collection, Collection<?> another) {
        if (collection == another) {
            return true;
        }
        if (another instanceof ByteCollection) {
            ByteCollection c2 = (ByteCollection)another;
            if (collection instanceof ByteSet && c2 instanceof ByteSet && collection.size() < another.size()) {
                return false;
            }
            if (c2 instanceof InternalByteCollectionOps) {
                return ((InternalByteCollectionOps)c2).allContainingIn(collection);
            }
            return c2.forEachWhile(new BytePredicate(){

                public boolean test(byte value) {
                    return collection.contains(value);
                }
            });
        }
        for (Object o : another) {
            if (collection.contains(((Byte)o).byteValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean addAll(ByteCollection collection, Collection<? extends Byte> another) {
        if (collection == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = collection.sizeAsLong() + Containers.sizeAsLong(another);
        collection.ensureCapacity(maxPossibleSize);
        if (another instanceof ByteCollection) {
            if (another instanceof InternalByteCollectionOps) {
                return ((InternalByteCollectionOps)((Object)another)).reverseAddAllTo(collection);
            }
            class AddAll
            implements ByteConsumer {
                boolean collectionChanged = false;
                final /* synthetic */ ByteCollection val$collection;

                AddAll(ByteCollection byteCollection) {
                    this.val$collection = byteCollection;
                }

                public void accept(byte value) {
                    this.collectionChanged |= this.val$collection.add(value);
                }
            }
            AddAll addAll = new AddAll(collection);
            ((ByteCollection)another).forEach((ByteConsumer)addAll);
            return addAll.collectionChanged;
        }
        boolean collectionChanged = false;
        for (Byte by : another) {
            collectionChanged |= collection.add(by.byteValue());
        }
        return collectionChanged;
    }

    private CommonByteCollectionOps() {
    }
}

