/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.impl.hash;

import net.openhft.collect.hash.*;
import net.openhft.collect.map.CharByteMap;
import net.openhft.collect.map.hash.HashCharByteMapFactory;

import java.util.Map;


public abstract class LHashSeparateKVCharByteMapFactorySO
        extends CharLHashFactory 
        implements HashCharByteMapFactory {

    LHashSeparateKVCharByteMapFactorySO(HashConfig hashConf, int defaultExpectedSize
            , char lower, char upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    

    

    


     MutableLHashSeparateKVCharByteMapGO uninitializedMutableMap() {
        return new MutableLHashSeparateKVCharByteMap();
    }
     UpdatableLHashSeparateKVCharByteMapGO uninitializedUpdatableMap() {
        return new UpdatableLHashSeparateKVCharByteMap();
    }
     ImmutableLHashSeparateKVCharByteMapGO uninitializedImmutableMap() {
        return new ImmutableLHashSeparateKVCharByteMap();
    }

    @Override
    public  MutableLHashSeparateKVCharByteMapGO newMutableMap(int expectedSize) {
        MutableLHashSeparateKVCharByteMapGO map = uninitializedMutableMap();
        map.init(configWrapper, expectedSize, getFree());
        return map;
    }

    

    @Override
    public  UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(int expectedSize) {
        UpdatableLHashSeparateKVCharByteMapGO map = uninitializedUpdatableMap();
        map.init(configWrapper, expectedSize, getFree());
        return map;
    }

    

    @Override
    public  UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(
            Map<Character, Byte> map) {
        if (map instanceof CharByteMap) {
            if (map instanceof SeparateKVCharByteLHash) {
                SeparateKVCharByteLHash hash = (SeparateKVCharByteLHash) map;
                if (hash.hashConfig().equals(hashConf)) {
                    UpdatableLHashSeparateKVCharByteMapGO res = uninitializedUpdatableMap();
                    res.copy(hash);
                    return res;
                }
            }
            UpdatableLHashSeparateKVCharByteMapGO res = newUpdatableMap(map.size());
            res.putAll(map);
            return res;
        }
        UpdatableLHashSeparateKVCharByteMapGO res = newUpdatableMap(map.size());
        for (Map.Entry<Character, Byte> entry : map.entrySet()) {
            res.put(entry.getKey(), entry.getValue());
        }
        return res;
    }
}

