/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.collect.hash.HashOverflowException;
import net.openhft.collect.impl.CharArrays;
import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.HashConfigWrapper;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.SeparateKVCharLHash;
import net.openhft.collect.impl.hash.UpdatableLHash;

public abstract class UpdatableSeparateKVCharLHashSO
extends UpdatableLHash
implements SeparateKVCharLHash,
PrimitiveConstants,
UnsafeConstants {
    char freeValue;
    char[] set;

    void copy(SeparateKVCharLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (char[])hash.keys().clone();
    }

    void move(SeparateKVCharLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, char freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public char freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public char removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains(((Character)key).charValue());
    }

    public boolean contains(char key) {
        return this.index(key) >= 0;
    }

    int index(char key) {
        char free = this.freeValue;
        if (key != free) {
            char[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVCharKeyMixing.mix(key) & capacityMask;
            char cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }

    private char findNewFreeOrRemoved() {
        char newFree;
        block6: {
            int mc = this.modCount();
            int size = this.size();
            if (size >= 65535) {
                throw new HashOverflowException();
            }
            char free = this.freeValue;
            char[] keys = this.set;
            int capacity = this.capacity();
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (size > 49152) {
                int nf = ((Random)random).nextInt(65536) * 21859;
                for (int i = 0; i < 65536; ++i) {
                    newFree = (char)(nf += 21859);
                    if (newFree == free || this.index(newFree) >= 0) {
                        continue;
                    }
                    break block6;
                }
                if (mc != this.modCount()) {
                    throw new ConcurrentModificationException();
                }
                throw new AssertionError((Object)"Impossible state");
            }
            while ((newFree = (char)((Random)random).nextInt()) == free || this.index(newFree) >= 0) {
            }
        }
        return newFree;
    }

    char changeFree() {
        int mc = this.modCount();
        char newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        CharArrays.replaceAll(this.set, this.freeValue, newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.set = new char[capacity];
        if (this.freeValue != '\u0000') {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.set, this.freeValue);
    }
}

