/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.LongCollection;
import net.openhft.collect.LongCursor;
import net.openhft.collect.LongIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractLongValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonShortLongMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.InternalShortLongMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVShortLongQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVShortLongMapSO;
import net.openhft.collect.map.ShortLongCursor;
import net.openhft.collect.set.LongSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.ShortLongConsumer;
import net.openhft.function.ShortLongPredicate;
import net.openhft.function.ShortLongToLongFunction;
import net.openhft.function.ShortToLongFunction;

public class UpdatableQHashSeparateKVShortLongMapGO
extends UpdatableQHashSeparateKVShortLongMapSO {
    @Override
    final void copy(SeparateKVShortLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVShortLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public long defaultValue() {
        return 0L;
    }

    @Override
    public boolean containsEntry(short key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public long get(short key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Long getOrDefault(Object key, Long defaultValue) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public long getOrDefault(short key, long defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Short, ? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept((Short)key, (Long)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ShortLongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ShortLongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ShortLongCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonShortLongMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalShortLongMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalShortLongMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Short, Long>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public LongCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            long val = vals[i];
            hashCode += key ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        short[] newKeys = this.set;
        int capacity = newKeys.length;
        long[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            int index = QHash.SeparateKVShortKeyMixing.mix(key) % capacity;
            if (newKeys[index] != free) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] == free) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] == free) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Long put(Short key, Long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        long[] vals = this.values;
        long prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public long put(short key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        long[] vals = this.values;
        long prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Long putIfAbsent(Short key, Long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public long putIfAbsent(short key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(short key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Long compute(Short key, BiFunction<? super Short, ? super Long, ? extends Long> remappingFunction) {
        Long newValue;
        int index;
        long[] vals;
        short k;
        block13: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            short free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            short[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVShortKeyMixing.mix(k) % capacity;
            short cur = keys[index];
            if (cur != k) {
                Long newValue2;
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Short)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Short)k, (Long)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    public long compute(short key, ShortLongToLongFunction remappingFunction) {
        long newValue;
        int index;
        long[] vals;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            short[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVShortKeyMixing.mix(key) % capacity;
            short cur = keys[index];
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                long newValue2 = remappingFunction.applyAsLong(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue2;
                this.postInsertHook();
                return newValue2;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsLong(key, vals[index]);
        return newValue;
    }

    @Override
    public Long computeIfAbsent(Short key, Function<? super Short, ? extends Long> mappingFunction) {
        Long value;
        short k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        short[] keys = this.set;
        long[] vals = this.values;
        int capacity = keys.length;
        int index = QHash.SeparateKVShortKeyMixing.mix(k) % capacity;
        short cur = keys[index];
        if (cur != free) {
            if (cur == k) {
                return vals[index];
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == k) {
                    return vals[bIndex];
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == k) {
                    return vals[fIndex];
                }
                step += 2;
            }
        }
        if ((value = mappingFunction.apply((Short)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public long computeIfAbsent(short key, ShortToLongFunction mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        short[] keys = this.set;
        long[] vals = this.values;
        int capacity = keys.length;
        int index = QHash.SeparateKVShortKeyMixing.mix(key) % capacity;
        short cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return vals[index];
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return vals[bIndex];
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return vals[fIndex];
                }
                step += 2;
            }
        }
        long value = mappingFunction.applyAsLong(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    @Override
    public Long computeIfPresent(Short key, BiFunction<? super Short, ? super Long, ? extends Long> remappingFunction) {
        short k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] vals = this.values;
            Long newValue = remappingFunction.apply((Short)k, (Long)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public long computeIfPresent(short key, ShortLongToLongFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long newValue;
            long[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsLong(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Long merge(Short key, Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        Long newValue;
        int index;
        long[] vals;
        block13: {
            short k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            short free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            short[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVShortKeyMixing.mix(k) % capacity;
            short cur = keys[index];
            if (cur != k) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Long)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    public long merge(short key, long value, LongBinaryOperator remappingFunction) {
        long newValue;
        int index;
        long[] vals;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            short[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVShortKeyMixing.mix(key) % capacity;
            short cur = keys[index];
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsLong(vals[index], value);
        return newValue;
    }

    public long addValue(short key, long value) {
        long newValue;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        vals[index] = newValue = vals[index] + value;
        return newValue;
    }

    public long addValue(short key, long addition, long defaultValue) {
        long newValue;
        long value = defaultValue + addition;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        vals[index] = newValue = vals[index] + addition;
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Short, ? extends Long> m) {
        CommonShortLongMapOps.putAll(this, m);
    }

    @Override
    public Long replace(Short key, Long value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            long oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public long replace(short key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            long oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Short key, Long oldValue, Long newValue) {
        return this.replace((short)key, (long)oldValue, (long)newValue);
    }

    @Override
    public boolean replace(short key, long oldValue, long newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Short, ? super Long, ? extends Long> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            vals[i] = function.apply((Short)key, (Long)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ShortLongToLongFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            vals[i] = function.applyAsLong(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Long remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(short key) {
        throw new UnsupportedOperationException();
    }

    public long remove(short key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Short)key, (Long)value);
    }

    public boolean remove(short key, long value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ShortLongPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ShortLongCursor {
        final short[] keys;
        final long[] vals;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            this.curKey = free = (this.free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue);
        }

        public void forEachForward(ShortLongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                short[] keys = this.keys;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    short key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements LongCursor {
        final short[] keys;
        final long[] vals;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            this.curKey = free = (this.free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue);
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                short[] keys = this.keys;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    short key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements LongIterator {
        final short[] keys;
        final long[] vals;
        final short free;
        int expectedModCount;
        int nextIndex;
        long next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            this.vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            short free = this.free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                    short[] keys = this.keys;
                    short free = this.free;
                    long prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Long)vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, Long>> {
        final short[] keys;
        final long[] vals;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            this.curKey = free = (this.free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, Long> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                short[] keys = this.keys;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    short key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, Long>> {
        final short[] keys;
        final long[] vals;
        final short free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            this.vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            short free = this.free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                short key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                    short[] keys = this.keys;
                    short free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        short key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractLongValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVShortLongMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVShortLongMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashSeparateKVShortLongMapGO.this.containsValue(o);
        }

        public boolean contains(long v) {
            return UpdatableQHashSeparateKVShortLongMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Long)vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(LongPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(LongCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(LongCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(LongSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeLong(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public LongIterator iterator() {
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public LongCursor cursor() {
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public long[] toLongArray() {
            int size = this.size();
            long[] result = new long[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public long[] toArray(long[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new long[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0L;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0L;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeLong((Long)o);
        }

        public boolean removeLong(long v) {
            return UpdatableQHashSeparateKVShortLongMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVShortLongMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(LongPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ShortLongEntry {
        private short key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(short key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ShortLongEntry {
        int modCount;
        private final int index;
        final short key;
        private long value;

        MutableEntry(int modCount, int index, short key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Long setValue(Long newValue) {
            long unwrappedNewValue;
            if (this.modCount != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            long oldValue = this.value;
            this.value = unwrappedNewValue = newValue.longValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            UpdatableQHashSeparateKVShortLongMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ShortLongEntry
    extends AbstractEntry<Short, Long> {
        ShortLongEntry() {
        }

        abstract short key();

        @Override
        public final Short getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Long getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                short k2 = (Short)e2.getKey();
                long v2 = (Long)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Short, Long>>
    implements HashObjSet<Map.Entry<Short, Long>>,
    InternalObjCollectionOps<Map.Entry<Short, Long>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Short, Long>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashSeparateKVShortLongMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVShortLongMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashSeparateKVShortLongMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashSeparateKVShortLongMapGO.this.containsEntry((Short)e.getKey(), (Long)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Short, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Short, Long>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Short, Long>> iterator() {
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Short, Long>> cursor() {
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Short, Long>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVShortLongMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVShortLongMapGO.this.modCount();
            short free = UpdatableQHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = UpdatableQHashSeparateKVShortLongMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVShortLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVShortLongMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                short key = (Short)e.getKey();
                long value = (Long)e.getValue();
                return UpdatableQHashSeparateKVShortLongMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Short, Long>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVShortLongMapGO.this.clear();
        }
    }
}

