/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalDoubleIntMapOps;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVDoubleIntQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVDoubleKeyMap;
import net.openhft.collect.map.hash.HashDoubleIntMap;

public abstract class UpdatableQHashSeparateKVDoubleIntMapSO
extends UpdatableQHashSeparateKVDoubleKeyMap
implements HashDoubleIntMap,
InternalDoubleIntMapOps,
SeparateKVDoubleIntQHash {
    int[] values;

    void copy(SeparateKVDoubleIntQHash hash) {
        super.copy(hash);
        this.values = (int[])hash.valueArray().clone();
    }

    void move(SeparateKVDoubleIntQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public int[] valueArray() {
        return this.values;
    }

    int valueIndex(int value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(int value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Integer)value);
    }

    int insert(long key, int value) {
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(key) % capacity;
        long cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new int[capacity];
    }
}

