/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.IntCollection;
import net.openhft.collect.IntCursor;
import net.openhft.collect.IntIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractIntValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonCharIntMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalCharIntMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVCharIntQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVCharIntMapSO;
import net.openhft.collect.map.CharIntCursor;
import net.openhft.collect.set.IntSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.CharIntConsumer;
import net.openhft.function.CharIntPredicate;
import net.openhft.function.CharIntToIntFunction;
import net.openhft.function.CharToIntFunction;

public class UpdatableQHashSeparateKVCharIntMapGO
extends UpdatableQHashSeparateKVCharIntMapSO {
    @Override
    final void copy(SeparateKVCharIntQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVCharIntQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(char key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public int get(char key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Integer getOrDefault(Object key, Integer defaultValue) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public int getOrDefault(char key, int defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Character, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(Character.valueOf(key), (Integer)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(CharIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(CharIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public CharIntCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharIntMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalCharIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalCharIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Character, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            hashCode += key ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        char[] newKeys = this.set;
        int capacity = newKeys.length;
        int[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            int index = QHash.SeparateKVCharKeyMixing.mix(key) % capacity;
            if (newKeys[index] != free) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] == free) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] == free) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Integer put(Character key, Integer value) {
        int index = this.insert(key.charValue(), value);
        if (index < 0) {
            return null;
        }
        int[] vals = this.values;
        int prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public int put(char key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        int[] vals = this.values;
        int prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Integer putIfAbsent(Character key, Integer value) {
        int index = this.insert(key.charValue(), value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public int putIfAbsent(char key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(char key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Integer compute(Character key, BiFunction<? super Character, ? super Integer, ? extends Integer> remappingFunction) {
        Integer newValue;
        int index;
        int[] vals;
        char k;
        block13: {
            k = key.charValue();
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            char[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVCharKeyMixing.mix(k) % capacity;
            char cur = keys[index];
            if (cur != k) {
                Integer newValue2;
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = remappingFunction.apply(Character.valueOf(k), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(k), (Integer)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    public int compute(char key, CharIntToIntFunction remappingFunction) {
        int newValue;
        int index;
        int[] vals;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            char[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVCharKeyMixing.mix(key) % capacity;
            char cur = keys[index];
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newValue = remappingFunction.applyAsInt(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsInt(key, vals[index]);
        return newValue;
    }

    @Override
    public Integer computeIfAbsent(Character key, Function<? super Character, ? extends Integer> mappingFunction) {
        Integer value;
        char k = key.charValue();
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        char[] keys = this.set;
        int[] vals = this.values;
        int capacity = keys.length;
        int index = QHash.SeparateKVCharKeyMixing.mix(k) % capacity;
        char cur = keys[index];
        if (cur != free) {
            if (cur == k) {
                return vals[index];
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == k) {
                    return vals[bIndex];
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == k) {
                    return vals[fIndex];
                }
                step += 2;
            }
        }
        if ((value = mappingFunction.apply(Character.valueOf(k))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public int computeIfAbsent(char key, CharToIntFunction mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] keys = this.set;
        int[] vals = this.values;
        int capacity = keys.length;
        int index = QHash.SeparateKVCharKeyMixing.mix(key) % capacity;
        char cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return vals[index];
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return vals[bIndex];
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return vals[fIndex];
                }
                step += 2;
            }
        }
        int value = mappingFunction.applyAsInt(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    @Override
    public Integer computeIfPresent(Character key, BiFunction<? super Character, ? super Integer, ? extends Integer> remappingFunction) {
        char k = key.charValue();
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            int[] vals = this.values;
            Integer newValue = remappingFunction.apply(Character.valueOf(k), (Integer)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public int computeIfPresent(char key, CharIntToIntFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            int newValue;
            int[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsInt(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Integer merge(Character key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        Integer newValue;
        int index;
        int[] vals;
        block13: {
            char k = key.charValue();
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            char[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVCharKeyMixing.mix(k) % capacity;
            char cur = keys[index];
            if (cur != k) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    public int merge(char key, int value, IntBinaryOperator remappingFunction) {
        int newValue;
        int index;
        int[] vals;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            char[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVCharKeyMixing.mix(key) % capacity;
            char cur = keys[index];
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsInt(vals[index], value);
        return newValue;
    }

    public int addValue(char key, int value) {
        int newValue;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        int[] vals = this.values;
        vals[index] = newValue = vals[index] + value;
        return newValue;
    }

    public int addValue(char key, int addition, int defaultValue) {
        int newValue;
        int value = defaultValue + addition;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        int[] vals = this.values;
        vals[index] = newValue = vals[index] + addition;
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Character, ? extends Integer> m) {
        CommonCharIntMapOps.putAll(this, m);
    }

    @Override
    public Integer replace(Character key, Integer value) {
        int index = this.index(key.charValue());
        if (index >= 0) {
            int[] vals = this.values;
            int oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public int replace(char key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            int oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Character key, Integer oldValue, Integer newValue) {
        return this.replace(key.charValue(), (int)oldValue, (int)newValue);
    }

    @Override
    public boolean replace(char key, int oldValue, int newValue) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Character, ? super Integer, ? extends Integer> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            vals[i] = function.apply(Character.valueOf(key), (Integer)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(CharIntToIntFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            vals[i] = function.applyAsInt(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(char key) {
        throw new UnsupportedOperationException();
    }

    public int remove(char key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), (Integer)value);
    }

    public boolean remove(char key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(CharIntPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements CharIntCursor {
        final char[] keys;
        final int[] vals;
        final char free;
        int expectedModCount;
        int index;
        char curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            this.curKey = free = (this.free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue);
        }

        public void forEachForward(CharIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final char[] keys;
        final int[] vals;
        final char free;
        int expectedModCount;
        int index;
        char curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            this.curKey = free = (this.free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue);
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final char[] keys;
        final int[] vals;
        final char free;
        int expectedModCount;
        int nextIndex;
        int next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            this.vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            char free = this.free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                    char[] keys = this.keys;
                    char free = this.free;
                    int prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Integer)vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Integer>> {
        final char[] keys;
        final int[] vals;
        final char free;
        int expectedModCount;
        int index;
        char curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            this.curKey = free = (this.free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Integer> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Integer>> {
        final char[] keys;
        final int[] vals;
        final char free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            this.vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            char free = this.free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                char key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                    char[] keys = this.keys;
                    char free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        char key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVCharIntMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVCharIntMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashSeparateKVCharIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return UpdatableQHashSeparateKVCharIntMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Integer)vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeInt(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public IntCursor cursor() {
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return UpdatableQHashSeparateKVCharIntMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVCharIntMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends CharIntEntry {
        private char key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends CharIntEntry {
        int modCount;
        private final int index;
        final char key;
        private int value;

        MutableEntry(int modCount, int index, char key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public Integer setValue(Integer newValue) {
            int unwrappedNewValue;
            if (this.modCount != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            int oldValue = this.value;
            this.value = unwrappedNewValue = newValue.intValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(int newValue) {
            UpdatableQHashSeparateKVCharIntMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class CharIntEntry
    extends AbstractEntry<Character, Integer> {
        CharIntEntry() {
        }

        abstract char key();

        @Override
        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract int value();

        @Override
        public final Integer getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Integer>>
    implements HashObjSet<Map.Entry<Character, Integer>>,
    InternalObjCollectionOps<Map.Entry<Character, Integer>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Character, Integer>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashSeparateKVCharIntMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVCharIntMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashSeparateKVCharIntMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashSeparateKVCharIntMapGO.this.containsEntry(((Character)e.getKey()).charValue(), (Integer)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Character, Integer>> iterator() {
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Integer>> cursor() {
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVCharIntMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVCharIntMapGO.this.modCount();
            char free = UpdatableQHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = UpdatableQHashSeparateKVCharIntMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVCharIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVCharIntMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                int value = (Integer)e.getValue();
                return UpdatableQHashSeparateKVCharIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVCharIntMapGO.this.clear();
        }
    }
}

