/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.ShortCollection;
import net.openhft.collect.ShortCursor;
import net.openhft.collect.ShortIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.AbstractShortValueView;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonShortShortMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.InternalShortShortMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.ParallelKVShortShortQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.UpdatableQHashParallelKVShortShortMapSO;
import net.openhft.collect.map.ShortShortCursor;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.ShortSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.ShortBinaryOperator;
import net.openhft.function.ShortConsumer;
import net.openhft.function.ShortPredicate;
import net.openhft.function.ShortShortConsumer;
import net.openhft.function.ShortShortPredicate;
import net.openhft.function.ShortShortToShortFunction;
import net.openhft.function.ShortUnaryOperator;

public class UpdatableQHashParallelKVShortShortMapGO
extends UpdatableQHashParallelKVShortShortMapSO {
    final void copy(ParallelKVShortShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVShortShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(short key, short value) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (short)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return (short)(entry >>> 16) == value;
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return (short)(entry >>> 16) == value;
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == k) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == k) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return null;
                }
                step += 2;
            }
        }
        return null;
    }

    public short get(short key) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        return this.defaultValue();
    }

    @Override
    public Short getOrDefault(Object key, Short defaultValue) {
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == k) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == k) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public short getOrDefault(short key, short defaultValue) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Short, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            action.accept((Short)key, (Short)((short)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ShortShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            action.accept(key, (short)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ShortShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free || predicate.test(key, (short)(entry >>> 16))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ShortShortCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonShortShortMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalShortShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free || m.containsEntry(key, (short)(entry >>> 16))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalShortShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            m.justPut(key, (short)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Short, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            hashCode += key ^ (short)(entry >>> 16);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((short)(entry >>> 16));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newTab = this.table;
        int capacity = newTab.length;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            if (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2)) != free) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)bIndex << 2)) == free) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)fIndex << 2)) == free) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Short put(Short key, Short value) {
        short free;
        short k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value << 16;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = k & 0xFFFF | value << 16;
                    this.postInsertHook();
                    return null;
                }
                if (cur == k) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = k & 0xFFFF | value << 16;
                    this.postInsertHook();
                    return null;
                }
                if (cur == k) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        short prevValue = (short)(entry >>> 16);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    @Override
    public short put(short key, short value) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != key) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = key & 0xFFFF | value << 16;
                    this.postInsertHook();
                    return this.defaultValue();
                }
                if (cur == key) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = key & 0xFFFF | value << 16;
                    this.postInsertHook();
                    return this.defaultValue();
                }
                if (cur == key) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        short prevValue = (short)(entry >>> 16);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    @Override
    public Short putIfAbsent(Short key, Short value) {
        short free;
        short k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value << 16;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return (short)(entry >>> 16);
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (short)(entry = tab[bIndex])) == free) {
                this.incrementModCount();
                tab[bIndex] = k & 0xFFFF | value << 16;
                this.postInsertHook();
                return null;
            }
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (short)(entry = tab[fIndex])) == free) {
                this.incrementModCount();
                tab[fIndex] = k & 0xFFFF | value << 16;
                this.postInsertHook();
                return null;
            }
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            step += 2;
        }
    }

    @Override
    public short putIfAbsent(short key, short value) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (short)(entry >>> 16);
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (short)(entry = tab[bIndex])) == free) {
                this.incrementModCount();
                tab[bIndex] = key & 0xFFFF | value << 16;
                this.postInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (short)(entry = tab[fIndex])) == free) {
                this.incrementModCount();
                tab[fIndex] = key & 0xFFFF | value << 16;
                this.postInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            step += 2;
        }
    }

    @Override
    public void justPut(short key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putShort(this.table, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
    }

    @Override
    public Short compute(Short key, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int entry;
        int index;
        int[] tab;
        short k;
        block13: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            short free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                Short newValue2;
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (short)(entry = tab[bIndex])) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (short)(entry = tab[fIndex])) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Short)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = k & 0xFFFF | newValue2 << 16;
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Short)k, (Short)((short)(entry >>> 16)))) != null) {
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    public short compute(short key, ShortShortToShortFunction remappingFunction) {
        short newValue;
        int entry;
        int index;
        int[] tab;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (short)(entry = tab[bIndex])) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (short)(entry = tab[fIndex])) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newValue = remappingFunction.applyAsShort(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key & 0xFFFF | newValue << 16;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsShort(key, (short)(entry >>> 16));
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    @Override
    public Short computeIfAbsent(Short key, Function<? super Short, ? extends Short> mappingFunction) {
        Short value;
        short k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur != free) {
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == k) {
                    return (short)(entry >>> 16);
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == k) {
                    return (short)(entry >>> 16);
                }
                step += 2;
            }
        }
        if ((value = mappingFunction.apply((Short)k)) != null) {
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value << 16;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public short computeIfAbsent(short key, ShortUnaryOperator mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur != free) {
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return (short)(entry >>> 16);
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return (short)(entry >>> 16);
                }
                step += 2;
            }
        }
        short value = mappingFunction.applyAsShort(key);
        this.incrementModCount();
        tab[index] = key & 0xFFFF | value << 16;
        this.postInsertHook();
        return value;
    }

    @Override
    public Short computeIfPresent(Short key, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        short k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (k != free) {
            Short newValue;
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            if ((newValue = remappingFunction.apply((Short)k, (Short)((short)(entry >>> 16)))) != null) {
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public short computeIfPresent(short key, ShortShortToShortFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            short newValue = remappingFunction.applyAsShort(key, (short)(entry >>> 16));
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Short merge(Short key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int entry;
        int index;
        int[] tab;
        block13: {
            short k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            short free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (short)(entry = tab[bIndex])) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (short)(entry = tab[fIndex])) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                tab[index] = k & 0xFFFF | value << 16;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Short)((short)(entry >>> 16)), value)) != null) {
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    public short merge(short key, short value, ShortBinaryOperator remappingFunction) {
        int entry;
        int index;
        int[] tab;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (short)(entry = tab[bIndex])) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (short)(entry = tab[fIndex])) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                tab[index] = key & 0xFFFF | value << 16;
                this.postInsertHook();
                return value;
            }
        }
        short newValue = remappingFunction.applyAsShort((short)(entry >>> 16), value);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public short addValue(short key, short value) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = key & 0xFFFF | value << 16;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = key & 0xFFFF | value << 16;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        short newValue = (short)((short)(entry >>> 16) + value);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public short addValue(short key, short addition, short defaultValue) {
        short value = (short)(defaultValue + addition);
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = key & 0xFFFF | value << 16;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = key & 0xFFFF | value << 16;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        short newValue = (short)((short)(entry >>> 16) + addition);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Short, ? extends Short> m) {
        CommonShortShortMapOps.putAll(this, m);
    }

    @Override
    public Short replace(Short key, Short value) {
        short free;
        short k = key;
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            short oldValue = (short)(entry >>> 16);
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return null;
    }

    @Override
    public short replace(short key, short value) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            short oldValue = (short)(entry >>> 16);
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Short key, Short oldValue, Short newValue) {
        return this.replace((short)key, (short)oldValue, (short)newValue);
    }

    @Override
    public boolean replace(short key, short oldValue, short newValue) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((short)(entry >>> 16) == oldValue) {
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Short, ? super Short, ? extends Short> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.apply((Short)key, (Short)((short)(entry >>> 16))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ShortShortToShortFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.applyAsShort(key, (short)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Short remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(short key) {
        throw new UnsupportedOperationException();
    }

    public short remove(short key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Short)key, (Short)value);
    }

    public boolean remove(short key, short value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ShortShortPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ShortShortCursor {
        final int[] tab;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        short curValue;

        NoRemovedMapCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue);
        }

        public void forEachForward(ShortShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(key, (short)(entry >>> 16));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final int[] tab;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        short curValue;

        NoRemovedValueCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue);
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final int[] tab;
        final short free;
        int expectedModCount;
        int nextIndex;
        short next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            short free = this.free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((short)entry == free) continue;
                this.next = (short)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                    int[] tab = this.tab;
                    short free = this.free;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        if ((short)entry == free) continue;
                        this.next = (short)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, Short>> {
        final int[] tab;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        short curValue;

        NoRemovedEntryCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (short)(entry >>> 16)));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, Short> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, Short>> {
        final int[] tab;
        final short free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            short free = this.free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                short key = (short)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (short)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (short)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                    int[] tab = this.tab;
                    short free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        short key = (short)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (short)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVShortShortMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVShortShortMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashParallelKVShortShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return UpdatableQHashParallelKVShortShortMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free || predicate.test((short)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free || c.contains((short)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                changed |= c.add((short)(entry >>> 16));
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                changed |= s.removeShort((short)(entry >>> 16));
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ShortCursor cursor() {
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                result[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                a[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                result[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                a[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                sb.append(' ').append((short)(entry >>> 16)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return UpdatableQHashParallelKVShortShortMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVShortShortMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(ShortPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ShortShortEntry {
        private short key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(short key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ShortShortEntry {
        int modCount;
        private final int index;
        final short key;
        private short value;

        MutableEntry(int modCount, int index, short key, short value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }

        @Override
        public Short setValue(Short newValue) {
            short unwrappedNewValue;
            if (this.modCount != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            short oldValue = this.value;
            this.value = unwrappedNewValue = newValue.shortValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(short newValue) {
            UnsafeConstants.U.putShort(UpdatableQHashParallelKVShortShortMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), newValue);
        }
    }

    abstract class ShortShortEntry
    extends AbstractEntry<Short, Short> {
        ShortShortEntry() {
        }

        abstract short key();

        @Override
        public final Short getKey() {
            return this.key();
        }

        abstract short value();

        @Override
        public final Short getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                short k2 = (Short)e2.getKey();
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Short, Short>>
    implements HashObjSet<Map.Entry<Short, Short>>,
    InternalObjCollectionOps<Map.Entry<Short, Short>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Short, Short>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashParallelKVShortShortMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVShortShortMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashParallelKVShortShortMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashParallelKVShortShortMapGO.this.containsEntry((Short)e.getKey(), (Short)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Short, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (short)(entry >>> 16)));
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Short, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || predicate.test(new MutableEntry(mc, i, key, (short)(entry >>> 16)))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Short, Short>> iterator() {
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Short, Short>> cursor() {
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || c.contains((Object)e.with(key, (short)(entry >>> 16)))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (short)(entry >>> 16)));
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Short, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16)));
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashParallelKVShortShortMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableQHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableQHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((short)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVShortShortMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                short key = (Short)e.getKey();
                short value = (Short)e.getValue();
                return UpdatableQHashParallelKVShortShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Short, Short>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVShortShortMapGO.this.clear();
        }
    }
}

