/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.LongToDoubleFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.DoubleCollection;
import net.openhft.collect.DoubleCursor;
import net.openhft.collect.DoubleIterator;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractDoubleValueView;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonLongDoubleMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalDoubleCollectionOps;
import net.openhft.collect.impl.InternalLongDoubleMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ParallelKVLongDoubleQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.UpdatableQHashParallelKVLongDoubleMapSO;
import net.openhft.collect.map.LongDoubleCursor;
import net.openhft.collect.set.DoubleSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.LongDoubleConsumer;
import net.openhft.function.LongDoublePredicate;
import net.openhft.function.LongDoubleToDoubleFunction;

public class UpdatableQHashParallelKVLongDoubleMapGO
extends UpdatableQHashParallelKVLongDoubleMapSO {
    final void copy(ParallelKVLongDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVLongDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    @Override
    public boolean containsEntry(long key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == Double.doubleToLongBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return null;
    }

    public double get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return this.defaultValue();
    }

    @Override
    public Double getOrDefault(Object key, Double defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return defaultValue;
    }

    public double getOrDefault(long key, double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            action.accept((Long)key, (Double)Double.longBitsToDouble(tab[i + 1]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongDoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            action.accept(key, Double.longBitsToDouble(tab[i + 1]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongDoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free || predicate.test(key, Double.longBitsToDouble(tab[i + 1]))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public LongDoubleCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongDoubleMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalLongDoubleMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free || m.containsEntry(key, tab[i + 1])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalLongDoubleMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            m.justPut(key, tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Long, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            long val = tab[i + 1];
            hashCode += (int)(key ^ key >>> 32) ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Double.longBitsToDouble(tab[i + 1]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacity = newTab.length;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            int index = QHash.ParallelKVLongKeyMixing.mix(key) % capacity;
            if (newTab[index] != free) {
                int bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newTab[bIndex] == free) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newTab[fIndex] == free) {
                        index = fIndex;
                        break;
                    }
                    step += 4;
                }
            }
            newTab[index] = key;
            newTab[index + 1] = tab[i + 1];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Double put(Long key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        long[] tab = this.table;
        double prevValue = Double.longBitsToDouble(tab[index + 1]);
        tab[index + 1] = Double.doubleToLongBits(value);
        return prevValue;
    }

    @Override
    public double put(long key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        long[] tab = this.table;
        double prevValue = Double.longBitsToDouble(tab[index + 1]);
        tab[index + 1] = Double.doubleToLongBits(value);
        return prevValue;
    }

    @Override
    public Double putIfAbsent(Long key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        return Double.longBitsToDouble(this.table[index + 1]);
    }

    @Override
    public double putIfAbsent(long key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Double.longBitsToDouble(this.table[index + 1]);
    }

    @Override
    public void justPut(long key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return;
        }
        this.table[index + 1] = Double.doubleToLongBits(value);
    }

    @Override
    public void justPut(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    @Override
    public Double compute(Long key, BiFunction<? super Long, ? super Double, ? extends Double> remappingFunction) {
        Double newValue;
        int index;
        long[] tab;
        long k;
        block13: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix(k) % capacity;
            long cur = tab[index];
            if (cur != k) {
                Double newValue2;
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = tab[bIndex]) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = tab[fIndex]) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Long)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = k;
                    tab[index + 1] = Double.doubleToLongBits(newValue2);
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Long)k, (Double)Double.longBitsToDouble(tab[index + 1]))) != null) {
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    public double compute(long key, LongDoubleToDoubleFunction remappingFunction) {
        int index;
        long[] tab;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix(key) % capacity;
            long cur = tab[index];
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = tab[bIndex]) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = tab[fIndex]) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                double newValue = remappingFunction.applyAsDouble(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(tab[index + 1]));
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    @Override
    public Double computeIfAbsent(Long key, Function<? super Long, ? extends Double> mappingFunction) {
        Double value;
        long k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVLongKeyMixing.mix(k) % capacity;
        long cur = tab[index];
        if (cur != free) {
            if (cur == k) {
                return Double.longBitsToDouble(tab[index + 1]);
            }
            int bIndex = index;
            int fIndex = index;
            int step = 2;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = tab[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == k) {
                    return Double.longBitsToDouble(tab[bIndex + 1]);
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = tab[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == k) {
                    return Double.longBitsToDouble(tab[fIndex + 1]);
                }
                step += 4;
            }
        }
        if ((value = mappingFunction.apply((Long)k)) != null) {
            this.incrementModCount();
            tab[index] = k;
            tab[index + 1] = Double.doubleToLongBits(value);
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public double computeIfAbsent(long key, LongToDoubleFunction mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVLongKeyMixing.mix(key) % capacity;
        long cur = tab[index];
        if (cur != free) {
            if (cur == key) {
                return Double.longBitsToDouble(tab[index + 1]);
            }
            int bIndex = index;
            int fIndex = index;
            int step = 2;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = tab[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return Double.longBitsToDouble(tab[bIndex + 1]);
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = tab[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return Double.longBitsToDouble(tab[fIndex + 1]);
                }
                step += 4;
            }
        }
        double value = mappingFunction.applyAsDouble(key);
        this.incrementModCount();
        tab[index] = key;
        tab[index + 1] = Double.doubleToLongBits(value);
        this.postInsertHook();
        return value;
    }

    @Override
    public Double computeIfPresent(Long key, BiFunction<? super Long, ? super Double, ? extends Double> remappingFunction) {
        long k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            Double newValue = remappingFunction.apply((Long)k, (Double)Double.longBitsToDouble(tab[index + 1]));
            if (newValue != null) {
                tab[index + 1] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public double computeIfPresent(long key, LongDoubleToDoubleFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(tab[index + 1]));
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Double merge(Long key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        Double newValue;
        int index;
        long[] tab;
        block13: {
            long k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix(k) % capacity;
            long cur = tab[index];
            if (cur != k) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = tab[bIndex]) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = tab[fIndex]) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(tab[index + 1]), value)) != null) {
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    public double merge(long key, double value, DoubleBinaryOperator remappingFunction) {
        int index;
        long[] tab;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix(key) % capacity;
            long cur = tab[index];
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = tab[bIndex]) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = tab[fIndex]) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        double newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(tab[index + 1]), value);
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(long key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return value;
        }
        long[] tab = this.table;
        double newValue = Double.longBitsToDouble(tab[index + 1]) + value;
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(long key, double addition, double defaultValue) {
        double value = defaultValue + addition;
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return value;
        }
        long[] tab = this.table;
        double newValue = Double.longBitsToDouble(tab[index + 1]) + addition;
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Long, ? extends Double> m) {
        CommonLongDoubleMapOps.putAll(this, m);
    }

    @Override
    public Double replace(Long key, Double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            double oldValue = Double.longBitsToDouble(tab[index + 1]);
            tab[index + 1] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return null;
    }

    @Override
    public double replace(long key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            double oldValue = Double.longBitsToDouble(tab[index + 1]);
            tab[index + 1] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Long key, Double oldValue, Double newValue) {
        return this.replace((long)key, (double)oldValue, (double)newValue);
    }

    @Override
    public boolean replace(long key, double oldValue, double newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            if (tab[index + 1] == Double.doubleToLongBits(oldValue)) {
                tab[index + 1] = Double.doubleToLongBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super Double, ? extends Double> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            tab[i + 1] = Double.doubleToLongBits(function.apply((Long)key, (Double)Double.longBitsToDouble(tab[i + 1])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(LongDoubleToDoubleFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            tab[i + 1] = Double.doubleToLongBits(function.applyAsDouble(key, Double.longBitsToDouble(tab[i + 1])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Double remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public double remove(long key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, (Double)value);
    }

    public boolean remove(long key, double value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(LongDoublePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements LongDoubleCursor {
        final long[] tab;
        final long free;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue);
        }

        public void forEachForward(LongDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(key, Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.tab[this.index + 1] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        final long[] tab;
        final long free;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue);
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public double elem() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        final long[] tab;
        final long free;
        int expectedModCount;
        int nextIndex;
        double next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            long free = this.free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] == free) continue;
                this.next = Double.longBitsToDouble(tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    long free = this.free;
                    double prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        if (tab[nextI] == free) continue;
                        this.next = Double.longBitsToDouble(tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Double>> {
        final long[] tab;
        final long free;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Double> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Double>> {
        final long[] tab;
        final long free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            long free = this.free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Double> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    long free = this.free;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(long bits) {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || predicate.test(Double.longBitsToDouble(tab[i + 1]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || c.contains(tab[i + 1])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= c.add(Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= c.add(tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= s.removeDouble(Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= s.removeDouble(tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public DoubleCursor cursor() {
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                sb.append(' ').append(Double.longBitsToDouble(tab[i + 1])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeDouble(long bits) {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVLongDoubleMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Double> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(DoublePredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends LongDoubleEntry {
        private long key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends LongDoubleEntry {
        int modCount;
        private final int index;
        final long key;
        private long value;

        MutableEntry(int modCount, int index, long key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Double setValue(Double newValue) {
            long unwrappedNewValue;
            if (this.modCount != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            double oldValue = Double.longBitsToDouble(this.value);
            this.value = unwrappedNewValue = Double.doubleToLongBits(newValue);
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            UpdatableQHashParallelKVLongDoubleMapGO.this.table[this.index + 1] = newValue;
        }
    }

    abstract class LongDoubleEntry
    extends AbstractEntry<Long, Double> {
        LongDoubleEntry() {
        }

        abstract long key();

        @Override
        public final Long getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Double>>
    implements HashObjSet<Map.Entry<Long, Double>>,
    InternalObjCollectionOps<Map.Entry<Long, Double>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Long, Double>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashParallelKVLongDoubleMapGO.this.containsEntry((long)((Long)e.getKey()), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || predicate.test(new MutableEntry(mc, i, key, tab[i + 1]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Long, Double>> iterator() {
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Double>> cursor() {
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, tab[i + 1]));
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Double.longBitsToDouble(tab[i + 1]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVLongDoubleMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                double value = (Double)e.getValue();
                return UpdatableQHashParallelKVLongDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Double>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVLongDoubleMapGO.this.clear();
        }
    }
}

