/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.ByteCollection;
import net.openhft.collect.ByteCursor;
import net.openhft.collect.ByteIterator;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractByteValueView;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonByteByteMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalByteByteMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.ParallelKVByteByteLHash;
import net.openhft.collect.impl.hash.UpdatableLHashParallelKVByteByteMapSO;
import net.openhft.collect.map.ByteByteCursor;
import net.openhft.collect.set.ByteSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.ByteBinaryOperator;
import net.openhft.function.ByteByteConsumer;
import net.openhft.function.ByteBytePredicate;
import net.openhft.function.ByteByteToByteFunction;
import net.openhft.function.ByteConsumer;
import net.openhft.function.BytePredicate;
import net.openhft.function.ByteUnaryOperator;

public class UpdatableLHashParallelKVByteByteMapGO
extends UpdatableLHashParallelKVByteByteMapSO {
    final void copy(ParallelKVByteByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVByteByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(byte key, byte value) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (byte)(entry >>> 8) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue)) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(k) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return null;
        }
        return null;
    }

    public byte get(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    @Override
    public Byte getOrDefault(Object key, Byte defaultValue) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue)) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(k) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public byte getOrDefault(byte key, byte defaultValue) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Byte, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            action.accept((Byte)key, (Byte)((byte)(entry >>> 8)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ByteByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            action.accept(key, (byte)(entry >>> 8));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ByteBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free || predicate.test(key, (byte)(entry >>> 8))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ByteByteCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteByteMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalByteByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free || m.containsEntry(key, (byte)(entry >>> 8))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalByteByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            m.justPut(key, (byte)(entry >>> 8));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Byte, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            hashCode += key ^ (byte)(entry >>> 8);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((byte)(entry >>> 8));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        char[] newTab = this.table;
        int capacityMask = newTab.length - 1;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            if (U.getByte(newTab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1)) != free) {
                while (U.getByte(newTab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)(index = index - 1 & capacityMask) << 1)) != free) {
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Byte put(Byte key, Byte value) {
        byte free;
        byte k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix(k) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(k & 0xFF | value << 8);
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = (char)(k & 0xFF | value << 8);
                this.postInsertHook();
                return null;
            } while (cur != k);
        }
        byte prevValue = (byte)(entry >>> 8);
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
        return prevValue;
    }

    @Override
    public byte put(byte key, byte value) {
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(key & 0xFF | value << 8);
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != key) {
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = (char)(key & 0xFF | value << 8);
                this.postInsertHook();
                return this.defaultValue();
            } while (cur != key);
        }
        byte prevValue = (byte)(entry >>> 8);
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
        return prevValue;
    }

    @Override
    public Byte putIfAbsent(Byte key, Byte value) {
        byte free;
        byte k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix(k) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(k & 0xFF | value << 8);
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return (byte)(entry >>> 8);
        }
        do {
            if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = (char)(k & 0xFF | value << 8);
            this.postInsertHook();
            return null;
        } while (cur != k);
        return (byte)(entry >>> 8);
    }

    @Override
    public byte putIfAbsent(byte key, byte value) {
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(key & 0xFF | value << 8);
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (byte)(entry >>> 8);
        }
        do {
            if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = (char)(key & 0xFF | value << 8);
            this.postInsertHook();
            return this.defaultValue();
        } while (cur != key);
        return (byte)(entry >>> 8);
    }

    @Override
    public void justPut(byte key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putByte(this.table, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Byte compute(Byte key, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVByteKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (byte)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply((Byte)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = (char)(k & 255 | newValue << 8);
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)k, (Byte)((byte)(entry >>> 8)))) != null) {
            UpdatableLHashParallelKVByteByteMapGO.U.putByte(tab, UpdatableLHashParallelKVByteByteMapGO.CHAR_BASE + UpdatableLHashParallelKVByteByteMapGO.BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public byte compute(byte key, ByteByteToByteFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            entry = tab[index];
            cur = (byte)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsByte(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = (char)(key & 255 | newValue << 8);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsByte(key, (byte)(entry >>> 8));
        UpdatableLHashParallelKVByteByteMapGO.U.putByte(tab, UpdatableLHashParallelKVByteByteMapGO.CHAR_BASE + UpdatableLHashParallelKVByteByteMapGO.BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    @Override
    public Byte computeIfAbsent(Byte key, Function<? super Byte, ? extends Byte> mappingFunction) {
        Byte value;
        byte k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix(k) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur != free) {
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) {
                if (cur != k) continue;
                return (byte)(entry >>> 8);
            }
        }
        if ((value = mappingFunction.apply((Byte)k)) != null) {
            this.incrementModCount();
            tab[index] = (char)(k & 0xFF | value << 8);
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public byte computeIfAbsent(byte key, ByteUnaryOperator mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur != free) {
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) {
                if (cur != key) continue;
                return (byte)(entry >>> 8);
            }
        }
        byte value = mappingFunction.applyAsByte(key);
        this.incrementModCount();
        tab[index] = (char)(key & 0xFF | value << 8);
        this.postInsertHook();
        return value;
    }

    @Override
    public Byte computeIfPresent(Byte key, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        byte k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (k != free) {
            Byte newValue;
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(k) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply((Byte)k, (Byte)((byte)(entry >>> 8)))) != null) {
                U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public byte computeIfPresent(byte key, ByteByteToByteFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            byte newValue = remappingFunction.applyAsByte(key, (byte)(entry >>> 8));
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Byte merge(Byte key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        block5: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVByteKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (byte)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                tab[index] = (char)(k & 255 | value << 8);
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)((byte)(entry >>> 8)), value)) != null) {
            UpdatableLHashParallelKVByteByteMapGO.U.putByte(tab, UpdatableLHashParallelKVByteByteMapGO.CHAR_BASE + UpdatableLHashParallelKVByteByteMapGO.BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public byte merge(byte key, byte value, ByteBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            entry = tab[index];
            cur = (byte)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                tab[index] = (char)(key & 255 | value << 8);
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsByte((byte)(entry >>> 8), value);
        UpdatableLHashParallelKVByteByteMapGO.U.putByte(tab, UpdatableLHashParallelKVByteByteMapGO.CHAR_BASE + UpdatableLHashParallelKVByteByteMapGO.BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    public byte addValue(byte key, byte value) {
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(key & 0xFF | value << 8);
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = (char)(key & 0xFF | value << 8);
                this.postInsertHook();
                return value;
            } while (cur != key);
        }
        byte newValue = (byte)((byte)(entry >>> 8) + value);
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    public byte addValue(byte key, byte addition, byte defaultValue) {
        byte value = (byte)(defaultValue + addition);
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(key & 0xFF | value << 8);
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = (char)(key & 0xFF | value << 8);
                this.postInsertHook();
                return value;
            } while (cur != key);
        }
        byte newValue = (byte)((byte)(entry >>> 8) + addition);
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Byte, ? extends Byte> m) {
        CommonByteByteMapOps.putAll(this, m);
    }

    @Override
    public Byte replace(Byte key, Byte value) {
        byte free;
        byte k = key;
        if (k != (free = this.freeValue)) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(k) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            byte oldValue = (byte)(entry >>> 8);
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
            return oldValue;
        }
        return null;
    }

    @Override
    public byte replace(byte key, byte value) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            byte oldValue = (byte)(entry >>> 8);
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Byte key, Byte oldValue, Byte newValue) {
        return this.replace((byte)key, (byte)oldValue, (byte)newValue);
    }

    @Override
    public boolean replace(byte key, byte oldValue, byte newValue) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((byte)(entry >>> 8) == oldValue) {
                U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Byte, ? super Byte, ? extends Byte> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)i << 1), function.apply((Byte)key, (Byte)((byte)(entry >>> 8))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ByteByteToByteFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)i << 1), function.applyAsByte(key, (byte)(entry >>> 8)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Byte remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(byte key) {
        throw new UnsupportedOperationException();
    }

    public byte remove(byte key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, (Byte)value);
    }

    public boolean remove(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ByteBytePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ByteByteCursor {
        final char[] tab;
        final byte free;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedMapCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key, (byte)(entry >>> 8));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_VALUE_OFFSET + ((long)this.index << 1), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final char[] tab;
        final byte free;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedValueCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final char[] tab;
        final byte free;
        int expectedModCount;
        int nextIndex;
        byte next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                if ((byte)entry == free) continue;
                this.next = (byte)(entry >>> 8);
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                    char[] tab = this.tab;
                    byte free = this.free;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        char entry = tab[nextI];
                        if ((byte)entry == free) continue;
                        this.next = (byte)(entry >>> 8);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((Byte)((byte)(entry >>> 8)));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedEntryCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (byte)(entry >>> 8)));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Byte> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                byte key = (byte)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (byte)(entry >>> 8));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (byte)(entry >>> 8)));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Byte> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                    char[] tab = this.tab;
                    byte free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        char entry = tab[nextI];
                        byte key = (byte)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (byte)(entry >>> 8));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableLHashParallelKVByteByteMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVByteByteMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableLHashParallelKVByteByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return UpdatableLHashParallelKVByteByteMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((Byte)((byte)(entry >>> 8)));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free || predicate.test((byte)(entry >>> 8))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free || c.contains((byte)(entry >>> 8))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                changed |= c.add((byte)(entry >>> 8));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                changed |= s.removeByte((byte)(entry >>> 8));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ByteCursor cursor() {
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                result[resultIndex++] = (byte)(entry >>> 8);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                a[resultIndex++] = (byte)(entry >>> 8);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                result[resultIndex++] = (byte)(entry >>> 8);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                a[resultIndex++] = (byte)(entry >>> 8);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                sb.append(' ').append((byte)(entry >>> 8)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return UpdatableLHashParallelKVByteByteMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableLHashParallelKVByteByteMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Byte> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(BytePredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ByteByteEntry {
        private byte key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ByteByteEntry {
        int modCount;
        private final int index;
        final byte key;
        private byte value;

        MutableEntry(int modCount, int index, byte key, byte value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }

        @Override
        public Byte setValue(Byte newValue) {
            byte unwrappedNewValue;
            if (this.modCount != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            byte oldValue = this.value;
            this.value = unwrappedNewValue = newValue.byteValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(byte newValue) {
            UnsafeConstants.U.putByte(UpdatableLHashParallelKVByteByteMapGO.this.table, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_VALUE_OFFSET + ((long)this.index << 1), newValue);
        }
    }

    abstract class ByteByteEntry
    extends AbstractEntry<Byte, Byte> {
        ByteByteEntry() {
        }

        abstract byte key();

        @Override
        public final Byte getKey() {
            return this.key();
        }

        abstract byte value();

        @Override
        public final Byte getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Byte>>
    implements HashObjSet<Map.Entry<Byte, Byte>>,
    InternalObjCollectionOps<Map.Entry<Byte, Byte>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Byte, Byte>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashParallelKVByteByteMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableLHashParallelKVByteByteMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableLHashParallelKVByteByteMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashParallelKVByteByteMapGO.this.containsEntry((Byte)e.getKey(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (byte)(entry >>> 8));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (byte)(entry >>> 8));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (byte)(entry >>> 8)));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || predicate.test(new MutableEntry(mc, i, key, (byte)(entry >>> 8)))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Byte, Byte>> iterator() {
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Byte>> cursor() {
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || c.contains((Object)e.with(key, (byte)(entry >>> 8)))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (byte)(entry >>> 8)));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8)));
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableLHashParallelKVByteByteMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVByteByteMapGO.this.modCount();
            byte free = UpdatableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = UpdatableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((byte)(entry >>> 8));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVByteByteMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                byte value = (Byte)e.getValue();
                return UpdatableLHashParallelKVByteByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Byte>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableLHashParallelKVByteByteMapGO.this.clear();
        }
    }
}

