/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.hash.ShortHashFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.hash.ImmutableQHashShortSetGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.MutableQHashShortSetGO;
import net.openhft.collect.impl.hash.QHashShortSetFactorySO;
import net.openhft.collect.impl.hash.SeparateKVShortQHash;
import net.openhft.collect.impl.hash.UpdatableQHashShortSetGO;
import net.openhft.collect.set.hash.HashShortSet;
import net.openhft.collect.set.hash.HashShortSetFactory;
import net.openhft.function.Consumer;
import net.openhft.function.Predicate;
import net.openhft.function.ShortConsumer;

public abstract class QHashShortSetFactoryGO
extends QHashShortSetFactorySO {
    public QHashShortSetFactoryGO(HashConfig hashConf, int defaultExpectedSize, short lower, short upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashShortSetFactory thisWith(HashConfig var1, int var2, short var3, short var4);

    abstract HashShortSetFactory lHashLikeThisWith(HashConfig var1, int var2, short var3, short var4);

    abstract HashShortSetFactory qHashLikeThisWith(HashConfig var1, int var2, short var3, short var4);

    public final HashShortSetFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashShortSetFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public String toString() {
        return "HashShortSetFactory[" + this.commonString() + this.keySpecialString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashShortSetFactory) {
            HashShortSetFactory factory = (HashShortSetFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((ShortHashFactory)factory);
        }
        return false;
    }

    public int hashCode() {
        return this.keySpecialHashCode(this.commonHashCode());
    }

    private UpdatableQHashShortSetGO shrunk(UpdatableQHashShortSetGO set) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(set)) {
            set.shrink();
        }
        return set;
    }

    public UpdatableQHashShortSetGO newUpdatableSet() {
        return this.newUpdatableSet(this.getDefaultExpectedSize());
    }

    public MutableQHashShortSetGO newMutableSet() {
        return this.newMutableSet(this.getDefaultExpectedSize());
    }

    private static int sizeOr(Iterable elems, int defaultSize) {
        return elems instanceof Collection ? ((Collection)elems).size() : defaultSize;
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elements) {
        return this.newUpdatableSet((Iterable)elements, QHashShortSetFactoryGO.sizeOr(elements, this.getDefaultExpectedSize()));
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2) {
        long expectedSize = QHashShortSetFactoryGO.sizeOr(elems1, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, Containers.sizeAsInt(expectedSize += (long)QHashShortSetFactoryGO.sizeOr(elems2, 0)));
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3) {
        long expectedSize = QHashShortSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashShortSetFactoryGO.sizeOr(elems2, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, Containers.sizeAsInt(expectedSize += (long)QHashShortSetFactoryGO.sizeOr(elems3, 0)));
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4) {
        long expectedSize = QHashShortSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashShortSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashShortSetFactoryGO.sizeOr(elems3, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, Containers.sizeAsInt(expectedSize += (long)QHashShortSetFactoryGO.sizeOr(elems4, 0)));
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5) {
        long expectedSize = QHashShortSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashShortSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashShortSetFactoryGO.sizeOr(elems3, 0);
        expectedSize += (long)QHashShortSetFactoryGO.sizeOr(elems4, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, Containers.sizeAsInt(expectedSize += (long)QHashShortSetFactoryGO.sizeOr(elems5, 0)));
    }

    @Override
    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elements, int expectedSize) {
        return this.shrunk((UpdatableQHashShortSetGO)super.newUpdatableSet((Iterable)elements, expectedSize));
    }

    private static void addAll(UpdatableQHashShortSetGO set, Iterable<? extends Short> elems) {
        if (elems instanceof Collection) {
            set.addAll((Collection)elems);
        } else {
            Iterator<? extends Short> iterator = elems.iterator();
            while (iterator.hasNext()) {
                short e = iterator.next();
                set.add(e);
            }
        }
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, int expectedSize) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(expectedSize);
        QHashShortSetFactoryGO.addAll(set, elems1);
        QHashShortSetFactoryGO.addAll(set, elems2);
        return this.shrunk(set);
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(expectedSize);
        QHashShortSetFactoryGO.addAll(set, elems1);
        QHashShortSetFactoryGO.addAll(set, elems2);
        QHashShortSetFactoryGO.addAll(set, elems3);
        return this.shrunk(set);
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, int expectedSize) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(expectedSize);
        QHashShortSetFactoryGO.addAll(set, elems1);
        QHashShortSetFactoryGO.addAll(set, elems2);
        QHashShortSetFactoryGO.addAll(set, elems3);
        QHashShortSetFactoryGO.addAll(set, elems4);
        return this.shrunk(set);
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(expectedSize);
        QHashShortSetFactoryGO.addAll(set, elems1);
        QHashShortSetFactoryGO.addAll(set, elems2);
        QHashShortSetFactoryGO.addAll(set, elems3);
        QHashShortSetFactoryGO.addAll(set, elems4);
        QHashShortSetFactoryGO.addAll(set, elems5);
        return this.shrunk(set);
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterator<Short> elements) {
        return this.newUpdatableSet((Iterator)elements, this.getDefaultExpectedSize());
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterator<Short> elements, int expectedSize) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(expectedSize);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return this.shrunk(set);
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Consumer<ShortConsumer> elementsSupplier) {
        return this.newUpdatableSet((Consumer)elementsSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Consumer<ShortConsumer> elementsSupplier, int expectedSize) {
        final UpdatableQHashShortSetGO set = this.newUpdatableSet(expectedSize);
        elementsSupplier.accept((Object)new ShortConsumer(){

            public void accept(short e) {
                set.add(e);
            }
        });
        return this.shrunk(set);
    }

    public UpdatableQHashShortSetGO newUpdatableSet(short[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    public UpdatableQHashShortSetGO newUpdatableSet(short[] elements, int expectedSize) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(expectedSize);
        for (short e : elements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Short[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Short[] elements, int expectedSize) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(expectedSize);
        Short[] shortArray = elements;
        int n = shortArray.length;
        for (int i = 0; i < n; ++i) {
            short e = shortArray[i];
            set.add(e);
        }
        return this.shrunk(set);
    }

    public UpdatableQHashShortSetGO newUpdatableSetOf(short e1) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(1);
        set.add(e1);
        return set;
    }

    public UpdatableQHashShortSetGO newUpdatableSetOf(short e1, short e2) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    public UpdatableQHashShortSetGO newUpdatableSetOf(short e1, short e2, short e3) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    public UpdatableQHashShortSetGO newUpdatableSetOf(short e1, short e2, short e3, short e4) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    public UpdatableQHashShortSetGO newUpdatableSetOf(short e1, short e2, short e3, short e4, short e5, short ... restElements) {
        UpdatableQHashShortSetGO set = this.newUpdatableSet(5 + restElements.length);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        for (short e : restElements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    public HashShortSet newMutableSet(Iterable<Short> elements, int expectedSize) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, int expectedSize) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, int expectedSize) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    public HashShortSet newMutableSet(Iterable<Short> elements) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    public HashShortSet newMutableSet(Iterator<Short> elements) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    public HashShortSet newMutableSet(Iterator<Short> elements, int expectedSize) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    public HashShortSet newMutableSet(Consumer<ShortConsumer> elementsSupplier) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    public HashShortSet newMutableSet(Consumer<ShortConsumer> elementsSupplier, int expectedSize) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    public HashShortSet newMutableSet(short[] elements) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashShortSet newMutableSet(short[] elements, int expectedSize) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashShortSet newMutableSet(Short[] elements) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashShortSet newMutableSet(Short[] elements, int expectedSize) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashShortSet newMutableSetOf(short e1) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    public HashShortSet newMutableSetOf(short e1, short e2) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    public HashShortSet newMutableSetOf(short e1, short e2, short e3) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    public HashShortSet newMutableSetOf(short e1, short e2, short e3, short e4) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    public HashShortSet newMutableSetOf(short e1, short e2, short e3, short e4, short e5, short ... restElements) {
        MutableQHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }

    public HashShortSet newImmutableSet(Iterable<Short> elements, int expectedSize) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, int expectedSize) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, int expectedSize) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    public HashShortSet newImmutableSet(Iterable<Short> elements) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    public HashShortSet newImmutableSet(Iterator<Short> elements) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    public HashShortSet newImmutableSet(Iterator<Short> elements, int expectedSize) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    public HashShortSet newImmutableSet(Consumer<ShortConsumer> elementsSupplier) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    public HashShortSet newImmutableSet(Consumer<ShortConsumer> elementsSupplier, int expectedSize) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    public HashShortSet newImmutableSet(short[] elements) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashShortSet newImmutableSet(short[] elements, int expectedSize) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashShortSet newImmutableSet(Short[] elements) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashShortSet newImmutableSet(Short[] elements, int expectedSize) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashShortSet newImmutableSetOf(short e1) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    public HashShortSet newImmutableSetOf(short e1, short e2) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    public HashShortSet newImmutableSetOf(short e1, short e2, short e3) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    public HashShortSet newImmutableSetOf(short e1, short e2, short e3, short e4) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    public HashShortSet newImmutableSetOf(short e1, short e2, short e3, short e4, short e5, short ... restElements) {
        ImmutableQHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }
}

