/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.hash.IntHashFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableQHashSeparateKVIntDoubleMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.MutableQHashSeparateKVIntDoubleMapGO;
import net.openhft.collect.impl.hash.QHashSeparateKVIntDoubleMapFactorySO;
import net.openhft.collect.impl.hash.SeparateKVIntDoubleQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVIntDoubleMapGO;
import net.openhft.collect.map.hash.HashIntDoubleMap;
import net.openhft.collect.map.hash.HashIntDoubleMapFactory;
import net.openhft.function.Consumer;
import net.openhft.function.IntDoubleConsumer;
import net.openhft.function.Predicate;

public abstract class QHashSeparateKVIntDoubleMapFactoryGO
extends QHashSeparateKVIntDoubleMapFactorySO {
    QHashSeparateKVIntDoubleMapFactoryGO(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashIntDoubleMapFactory thisWith(HashConfig var1, int var2, int var3, int var4);

    abstract HashIntDoubleMapFactory lHashLikeThisWith(HashConfig var1, int var2, int var3, int var4);

    abstract HashIntDoubleMapFactory qHashLikeThisWith(HashConfig var1, int var2, int var3, int var4);

    public final HashIntDoubleMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashIntDoubleMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    final HashIntDoubleMapFactory withDomain(int lower, int upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public final HashIntDoubleMapFactory withKeysDomain(int lower, int upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public final HashIntDoubleMapFactory withKeysDomainComplement(int lower, int upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain(upper + 1, lower - 1);
    }

    public String toString() {
        return "HashIntDoubleMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashIntDoubleMapFactory) {
            HashIntDoubleMapFactory factory = (HashIntDoubleMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((IntHashFactory)factory) && Double.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public double getDefaultValue() {
        return 0.0;
    }

    private UpdatableQHashSeparateKVIntDoubleMapGO shrunk(UpdatableQHashSeparateKVIntDoubleMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableQHashSeparateKVIntDoubleMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Map<Integer, Double> map) {
        return this.shrunk((UpdatableQHashSeparateKVIntDoubleMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Map<Integer, Double> map1, Map<Integer, Double> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4, Map<Integer, Double> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, int expectedSize) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Double>)map1);
        map.putAll((Map<? extends Integer, ? extends Double>)map2);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Double>)map1);
        map.putAll((Map<? extends Integer, ? extends Double>)map2);
        map.putAll((Map<? extends Integer, ? extends Double>)map3);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4, int expectedSize) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Double>)map1);
        map.putAll((Map<? extends Integer, ? extends Double>)map2);
        map.putAll((Map<? extends Integer, ? extends Double>)map3);
        map.putAll((Map<? extends Integer, ? extends Double>)map4);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Double>)map1);
        map.putAll((Map<? extends Integer, ? extends Double>)map2);
        map.putAll((Map<? extends Integer, ? extends Double>)map3);
        map.putAll((Map<? extends Integer, ? extends Double>)map4);
        map.putAll((Map<? extends Integer, ? extends Double>)map5);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Consumer<IntDoubleConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Consumer<IntDoubleConsumer> entriesSupplier, int expectedSize) {
        final UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new IntDoubleConsumer(){

            public void accept(int k, double v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(int[] keys, double[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(int[] keys, double[] values, int expectedSize) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Integer[] keys, Double[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Integer[] keys, Double[] values, int expectedSize) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Iterable<Integer> keys, Iterable<Double> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMap(Iterable<Integer> keys, Iterable<Double> values, int expectedSize) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Integer> keysIt = keys.iterator();
        Iterator<Double> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMapOf(int k1, double v1) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMapOf(int k1, double v1, int k2, double v2) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMapOf(int k1, double v1, int k2, double v2, int k3, double v3) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMapOf(int k1, double v1, int k2, double v2, int k3, double v3, int k4, double v4) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableQHashSeparateKVIntDoubleMapGO newUpdatableMapOf(int k1, double v1, int k2, double v2, int k3, double v3, int k4, double v4, int k5, double v5) {
        UpdatableQHashSeparateKVIntDoubleMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashIntDoubleMap newMutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, int expectedSize) {
        MutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashIntDoubleMap newMutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize) {
        MutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashIntDoubleMap newMutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4, int expectedSize) {
        MutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashIntDoubleMap newMutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize) {
        MutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashIntDoubleMap newMutableMap(Map<Integer, Double> map) {
        MutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashIntDoubleMap newMutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2) {
        MutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashIntDoubleMap newMutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3) {
        MutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashIntDoubleMap newMutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4) {
        MutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashIntDoubleMap newMutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4, Map<Integer, Double> map5) {
        MutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashIntDoubleMap newMutableMap(Consumer<IntDoubleConsumer> entriesSupplier) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashIntDoubleMap newMutableMap(Consumer<IntDoubleConsumer> entriesSupplier, int expectedSize) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashIntDoubleMap newMutableMap(int[] keys, double[] values) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntDoubleMap newMutableMap(int[] keys, double[] values, int expectedSize) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntDoubleMap newMutableMap(Integer[] keys, Double[] values) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntDoubleMap newMutableMap(Integer[] keys, Double[] values, int expectedSize) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntDoubleMap newMutableMap(Iterable<Integer> keys, Iterable<Double> values) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashIntDoubleMap newMutableMap(Iterable<Integer> keys, Iterable<Double> values, int expectedSize) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashIntDoubleMap newMutableMapOf(int k1, double v1) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashIntDoubleMap newMutableMapOf(int k1, double v1, int k2, double v2) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashIntDoubleMap newMutableMapOf(int k1, double v1, int k2, double v2, int k3, double v3) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashIntDoubleMap newMutableMapOf(int k1, double v1, int k2, double v2, int k3, double v3, int k4, double v4) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashIntDoubleMap newMutableMapOf(int k1, double v1, int k2, double v2, int k3, double v3, int k4, double v4, int k5, double v5) {
        MutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, int expectedSize) {
        ImmutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize) {
        ImmutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4, int expectedSize) {
        ImmutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize) {
        ImmutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashIntDoubleMap newImmutableMap(Map<Integer, Double> map) {
        ImmutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2) {
        ImmutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3) {
        ImmutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4) {
        ImmutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1, Map<Integer, Double> map2, Map<Integer, Double> map3, Map<Integer, Double> map4, Map<Integer, Double> map5) {
        ImmutableQHashSeparateKVIntDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashIntDoubleMap newImmutableMap(Consumer<IntDoubleConsumer> entriesSupplier) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashIntDoubleMap newImmutableMap(Consumer<IntDoubleConsumer> entriesSupplier, int expectedSize) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashIntDoubleMap newImmutableMap(int[] keys, double[] values) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntDoubleMap newImmutableMap(int[] keys, double[] values, int expectedSize) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntDoubleMap newImmutableMap(Integer[] keys, Double[] values) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntDoubleMap newImmutableMap(Integer[] keys, Double[] values, int expectedSize) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntDoubleMap newImmutableMap(Iterable<Integer> keys, Iterable<Double> values) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashIntDoubleMap newImmutableMap(Iterable<Integer> keys, Iterable<Double> values, int expectedSize) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntDoubleQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashIntDoubleMap newImmutableMapOf(int k1, double v1) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashIntDoubleMap newImmutableMapOf(int k1, double v1, int k2, double v2) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashIntDoubleMap newImmutableMapOf(int k1, double v1, int k2, double v2, int k3, double v3) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashIntDoubleMap newImmutableMapOf(int k1, double v1, int k2, double v2, int k3, double v3, int k4, double v4) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashIntDoubleMap newImmutableMapOf(int k1, double v1, int k2, double v2, int k3, double v3, int k4, double v4, int k5, double v5) {
        ImmutableQHashSeparateKVIntDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

