/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.IntCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.ImmutableQHashIntSet;
import net.openhft.collect.impl.hash.ImmutableQHashIntSetGO;
import net.openhft.collect.impl.hash.IntQHashFactory;
import net.openhft.collect.impl.hash.MutableQHashIntSet;
import net.openhft.collect.impl.hash.MutableQHashIntSetGO;
import net.openhft.collect.impl.hash.SeparateKVIntQHash;
import net.openhft.collect.impl.hash.UpdatableQHashIntSet;
import net.openhft.collect.impl.hash.UpdatableQHashIntSetGO;
import net.openhft.collect.set.hash.HashIntSetFactory;

public abstract class QHashIntSetFactorySO
extends IntQHashFactory<MutableQHashIntSetGO>
implements HashIntSetFactory {
    QHashIntSetFactorySO(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    MutableQHashIntSetGO createNewMutable(int expectedSize, int free, int removed) {
        MutableQHashIntSet set = new MutableQHashIntSet();
        set.init(this.configWrapper, expectedSize, free, removed);
        return set;
    }

    MutableQHashIntSetGO uninitializedMutableSet() {
        return new MutableQHashIntSet();
    }

    UpdatableQHashIntSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashIntSet();
    }

    ImmutableQHashIntSetGO uninitializedImmutableSet() {
        return new ImmutableQHashIntSet();
    }

    public MutableQHashIntSetGO newMutableSet(int expectedSize) {
        return (MutableQHashIntSetGO)this.newMutableHash(expectedSize);
    }

    public UpdatableQHashIntSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashIntSet set = new UpdatableQHashIntSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterable<Integer> elements, int expectedSize) {
        if (elements instanceof IntCollection) {
            SeparateKVIntQHash hash;
            if (elements instanceof SeparateKVIntQHash && (hash = (SeparateKVIntQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashIntSet set = new UpdatableQHashIntSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashIntSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashIntSetGO set = this.newUpdatableSet(size);
        for (int e : elements) {
            set.add(e);
        }
        return set;
    }
}

