/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableSeparateKVShortLHashGO;

public abstract class MutableShortLHashSetSO
extends MutableSeparateKVShortLHashGO {
    @Override
    void removeAt(int index) {
        short keyToShift;
        int indexToRemove;
        short free = this.freeValue;
        short[] keys = this.set;
        int capacityMask = keys.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
            if ((LHash.SeparateKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = free;
        this.postRemoveHook();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        this.initForRehash(newCapacity);
        ++mc;
        short[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            int index = LHash.SeparateKVShortKeyMixing.mix(key) & capacityMask;
            if (newKeys[index] != free) {
                while (newKeys[index = index - 1 & capacityMask] != free) {
                }
            }
            newKeys[index] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }
}

