/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.collect.ShortCollection;
import net.openhft.collect.ShortCursor;
import net.openhft.collect.ShortIterator;
import net.openhft.collect.impl.hash.MutableSeparateKVShortQHashSO;
import net.openhft.collect.set.ShortSet;
import net.openhft.collect.set.hash.HashShortSet;
import net.openhft.function.ShortConsumer;
import net.openhft.function.ShortPredicate;

public abstract class MutableSeparateKVShortQHashGO
extends MutableSeparateKVShortQHashSO {
    @Override
    @Nonnull
    public short[] keys() {
        return this.set;
    }

    @Override
    public int capacity() {
        return this.set.length;
    }

    public void forEach(Consumer<? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept((Short)key);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Short)key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(key);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(ShortCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(ShortCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= c.add(key);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                changed |= c.add(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(ShortSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= s.removeShort(key);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                changed |= s.removeShort(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public ShortIterator iterator() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedIterator(mc);
        }
        return new NoRemovedIterator(mc);
    }

    public ShortCursor setCursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedCursor(mc);
        }
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = key;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                result[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = key;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                a[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public short[] toShortArray() {
        int size = this.size();
        short[] result = new short[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = key;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                result[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public short[] toArray(short[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new short[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = key;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                a[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                hashCode += key;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                hashCode += key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                sb.append(' ').append(key).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                sb.append(' ').append(key).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(short var1);

    public boolean removeIf(Predicate<? super Short> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || !filter.test((Short)key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || !filter.test((Short)key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(ShortPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashShortSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashShortSet thisC, @Nonnull ShortCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashShortSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof ShortCollection) {
            return this.retainAll(thisC, (ShortCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashShortSet thisC, @Nonnull ShortCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedCursor
    implements ShortCursor {
        final short[] keys;
        final short free;
        final short removed;
        int expectedModCount;
        int index;
        short curKey;

        SomeRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableSeparateKVShortQHashGO.this.set;
            this.index = this.keys.length;
            short free = this.free = MutableSeparateKVShortQHashGO.this.freeValue;
            this.removed = MutableSeparateKVShortQHashGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            short free = this.free;
            short removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableSeparateKVShortQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableSeparateKVShortQHashGO.this.modCount()) {
                short[] keys = this.keys;
                short free = this.free;
                short removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    short key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            short free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableSeparateKVShortQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableSeparateKVShortQHashGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableSeparateKVShortQHashGO.this.postRemoveHook();
        }
    }

    class SomeRemovedIterator
    implements ShortIterator {
        final short[] keys;
        final short free;
        final short removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        SomeRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableSeparateKVShortQHashGO.this.set;
            short[] keys = MutableSeparateKVShortQHashGO.this.set;
            short free = this.free = MutableSeparateKVShortQHashGO.this.freeValue;
            short removed = this.removed = MutableSeparateKVShortQHashGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                short key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableSeparateKVShortQHashGO.this.modCount()) {
                    this.index = nextI;
                    short[] keys = this.keys;
                    short free = this.free;
                    short removed = this.removed;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        short key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            short free = this.free;
            short removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Short)key);
            }
            if (nextI != this.nextIndex || mc != MutableSeparateKVShortQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            short free = this.free;
            short removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableSeparateKVShortQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableSeparateKVShortQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableSeparateKVShortQHashGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableSeparateKVShortQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements ShortCursor {
        final short[] keys;
        final short free;
        final short removed;
        int expectedModCount;
        int index;
        short curKey;

        NoRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableSeparateKVShortQHashGO.this.set;
            this.index = this.keys.length;
            short free = this.free = MutableSeparateKVShortQHashGO.this.freeValue;
            this.removed = MutableSeparateKVShortQHashGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableSeparateKVShortQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableSeparateKVShortQHashGO.this.modCount()) {
                short[] keys = this.keys;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    short key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            short free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableSeparateKVShortQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableSeparateKVShortQHashGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableSeparateKVShortQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedIterator
    implements ShortIterator {
        final short[] keys;
        final short free;
        final short removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableSeparateKVShortQHashGO.this.set;
            short[] keys = MutableSeparateKVShortQHashGO.this.set;
            short free = this.free = MutableSeparateKVShortQHashGO.this.freeValue;
            this.removed = MutableSeparateKVShortQHashGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                short key = keys[nextI];
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableSeparateKVShortQHashGO.this.modCount()) {
                    this.index = nextI;
                    short[] keys = this.keys;
                    short free = this.free;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        short key = keys[nextI];
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept((Short)key);
            }
            if (nextI != this.nextIndex || mc != MutableSeparateKVShortQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableSeparateKVShortQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableSeparateKVShortQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableSeparateKVShortQHashGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableSeparateKVShortQHashGO.this.postRemoveHook();
        }
    }
}

