/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.collect.impl.IntArrays;
import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.HashConfigWrapper;
import net.openhft.collect.impl.hash.MutableQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVIntQHash;

public abstract class MutableSeparateKVIntQHashSO
extends MutableQHash
implements SeparateKVIntQHash,
PrimitiveConstants,
UnsafeConstants {
    int freeValue;
    int removedValue;
    int[] set;

    void copy(SeparateKVIntQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.set = (int[])hash.keys().clone();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    void move(SeparateKVIntQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.set = hash.keys();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    final void init(HashConfigWrapper configWrapper, int size, int freeValue, int removedValue) {
        this.freeValue = freeValue;
        this.removedValue = removedValue;
        super.init(configWrapper, size);
    }

    @Override
    public int freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return true;
    }

    @Override
    public int removedValue() {
        return this.removedValue;
    }

    public boolean contains(Object key) {
        return this.contains((Integer)key);
    }

    public boolean contains(int key) {
        return this.index(key) >= 0;
    }

    int index(int key) {
        int free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
            int cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }

    private int findNewFreeOrRemoved() {
        int newFree;
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        int capacity = this.capacity();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((newFree = ((Random)random).nextInt()) == free || newFree == removed || this.index(newFree) >= 0) {
        }
        return newFree;
    }

    int changeFree() {
        int mc = this.modCount();
        int newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        IntArrays.replaceAll(this.set, this.freeValue, newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    int changeRemoved() {
        int mc = this.modCount();
        int newRemoved = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ++mc;
        if (!this.noRemoved()) {
            IntArrays.replaceAll(this.set, this.removedValue, newRemoved);
        }
        this.removedValue = newRemoved;
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newRemoved;
    }

    @Override
    void allocateArrays(int capacity) {
        this.set = new int[capacity];
        if (this.freeValue != 0) {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.set, this.freeValue);
    }

    @Override
    void removeAt(int index) {
        this.set[index] = this.removedValue;
    }
}

