/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.DoubleCollection;
import net.openhft.collect.DoubleCursor;
import net.openhft.collect.impl.CommonDoubleCollectionOps;
import net.openhft.collect.impl.CommonSetOps;
import net.openhft.collect.impl.InternalDoubleCollectionOps;
import net.openhft.collect.impl.hash.MutableDoubleQHashSetSO;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVDoubleQHash;
import net.openhft.collect.set.DoubleSet;
import net.openhft.collect.set.hash.HashDoubleSet;

public class MutableQHashDoubleSetGO
extends MutableDoubleQHashSetSO
implements HashDoubleSet,
InternalDoubleCollectionOps {
    @Override
    final void copy(SeparateKVDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonDoubleCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public DoubleCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Double e) {
        return this.add((double)e);
    }

    @Override
    public boolean add(long key) {
        block21: {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVDoubleKeyMixing.mix(key) % capacity;
            long cur = keys[index];
            if (cur != 0x7FFFFFFFFFFFFFFEL) {
                int firstRemoved;
                if (cur == key) {
                    return false;
                }
                if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                                index = bIndex;
                                break block21;
                            }
                            if (cur == key) {
                                return false;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                                index = fIndex;
                                break block21;
                            }
                            if (cur == key) {
                                return false;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block21;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block21;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.postRemovedSlotInsertHook();
                return true;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postFreeSlotInsertHook();
        return true;
    }

    public boolean add(double key) {
        return this.add(Double.doubleToLongBits(key));
    }

    public boolean addAll(@Nonnull Collection<? extends Double> c) {
        return CommonDoubleCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        return this.removeDouble((Double)key);
    }

    @Override
    boolean justRemove(long key) {
        return this.removeDouble(key);
    }

    @Override
    public boolean removeDouble(long key) {
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(key) % capacity;
        long cur = keys[index];
        if (cur != key) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return true;
    }

    public boolean removeDouble(double key) {
        return this.removeDouble(Double.doubleToLongBits(key));
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        if (c instanceof DoubleCollection) {
            InternalDoubleCollectionOps c2;
            if (c instanceof InternalDoubleCollectionOps && (c2 = (InternalDoubleCollectionOps)((Object)c)).size() < this.size()) {
                return c2.reverseRemoveAllFrom((DoubleSet)this);
            }
            return this.removeAll((HashDoubleSet)this, (DoubleCollection)c);
        }
        return this.removeAll((HashDoubleSet)this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

