/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.ShortCollection;
import net.openhft.collect.ShortCursor;
import net.openhft.collect.ShortIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.AbstractShortValueView;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonShortShortMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.InternalShortShortMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableLHashParallelKVShortShortMapSO;
import net.openhft.collect.impl.hash.MutableParallelKVShortLHashGO;
import net.openhft.collect.impl.hash.ParallelKVShortShortLHash;
import net.openhft.collect.map.ShortShortCursor;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.ShortSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.collect.set.hash.HashShortSet;
import net.openhft.function.ShortBinaryOperator;
import net.openhft.function.ShortConsumer;
import net.openhft.function.ShortPredicate;
import net.openhft.function.ShortShortConsumer;
import net.openhft.function.ShortShortPredicate;
import net.openhft.function.ShortShortToShortFunction;
import net.openhft.function.ShortUnaryOperator;

public class MutableLHashParallelKVShortShortMapGO
extends MutableLHashParallelKVShortShortMapSO {
    final void copy(ParallelKVShortShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVShortShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(short key, short value) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (short)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return null;
        }
        return null;
    }

    public short get(short key) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    @Override
    public Short getOrDefault(Object key, Short defaultValue) {
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public short getOrDefault(short key, short defaultValue) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Short, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            action.accept((Short)key, (Short)((short)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ShortShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            action.accept(key, (short)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ShortShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free || predicate.test(key, (short)(entry >>> 16))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ShortShortCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonShortShortMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalShortShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free || m.containsEntry(key, (short)(entry >>> 16))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalShortShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            m.justPut(key, (short)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Short, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            hashCode += key ^ (short)(entry >>> 16);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((short)(entry >>> 16));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newTab = this.table;
        int capacityMask = newTab.length - 1;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            if (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2)) != free) {
                while (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)(index = index - 1 & capacityMask) << 2)) != free) {
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Short put(Short key, Short value) {
        short free;
        short k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix(k) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value << 16;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = k & 0xFFFF | value << 16;
                this.postInsertHook();
                return null;
            } while (cur != k);
        }
        short prevValue = (short)(entry >>> 16);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    @Override
    public short put(short key, short value) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != key) {
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = key & 0xFFFF | value << 16;
                this.postInsertHook();
                return this.defaultValue();
            } while (cur != key);
        }
        short prevValue = (short)(entry >>> 16);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    @Override
    public Short putIfAbsent(Short key, Short value) {
        short free;
        short k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix(k) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value << 16;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return (short)(entry >>> 16);
        }
        do {
            if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value << 16;
            this.postInsertHook();
            return null;
        } while (cur != k);
        return (short)(entry >>> 16);
    }

    @Override
    public short putIfAbsent(short key, short value) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (short)(entry >>> 16);
        }
        do {
            if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        } while (cur != key);
        return (short)(entry >>> 16);
    }

    @Override
    public void justPut(short key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putShort(this.table, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Short compute(Short key, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVShortKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (short)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply((Short)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = k & 65535 | newValue << 16;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Short)k, (Short)((short)(entry >>> 16)))) != null) {
            MutableLHashParallelKVShortShortMapGO.U.putShort(tab, MutableLHashParallelKVShortShortMapGO.INT_BASE + MutableLHashParallelKVShortShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public short compute(short key, ShortShortToShortFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            entry = tab[index];
            cur = (short)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsShort(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key & 65535 | newValue << 16;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsShort(key, (short)(entry >>> 16));
        MutableLHashParallelKVShortShortMapGO.U.putShort(tab, MutableLHashParallelKVShortShortMapGO.INT_BASE + MutableLHashParallelKVShortShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    @Override
    public Short computeIfAbsent(Short key, Function<? super Short, ? extends Short> mappingFunction) {
        Short value;
        short k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix(k) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur != free) {
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) {
                if (cur != k) continue;
                return (short)(entry >>> 16);
            }
        }
        if ((value = mappingFunction.apply((Short)k)) != null) {
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value << 16;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public short computeIfAbsent(short key, ShortUnaryOperator mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur != free) {
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) {
                if (cur != key) continue;
                return (short)(entry >>> 16);
            }
        }
        short value = mappingFunction.applyAsShort(key);
        this.incrementModCount();
        tab[index] = key & 0xFFFF | value << 16;
        this.postInsertHook();
        return value;
    }

    @Override
    public Short computeIfPresent(Short key, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        short k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (k != free) {
            Short newValue;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply((Short)k, (Short)((short)(entry >>> 16)))) != null) {
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public short computeIfPresent(short key, ShortShortToShortFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            short newValue = remappingFunction.applyAsShort(key, (short)(entry >>> 16));
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Short merge(Short key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        block5: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVShortKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (short)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                tab[index] = k & 65535 | value << 16;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Short)((short)(entry >>> 16)), value)) != null) {
            MutableLHashParallelKVShortShortMapGO.U.putShort(tab, MutableLHashParallelKVShortShortMapGO.INT_BASE + MutableLHashParallelKVShortShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public short merge(short key, short value, ShortBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            entry = tab[index];
            cur = (short)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                tab[index] = key & 65535 | value << 16;
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsShort((short)(entry >>> 16), value);
        MutableLHashParallelKVShortShortMapGO.U.putShort(tab, MutableLHashParallelKVShortShortMapGO.INT_BASE + MutableLHashParallelKVShortShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public short addValue(short key, short value) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = key & 0xFFFF | value << 16;
                this.postInsertHook();
                return value;
            } while (cur != key);
        }
        short newValue = (short)((short)(entry >>> 16) + value);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public short addValue(short key, short addition, short defaultValue) {
        short value = (short)(defaultValue + addition);
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = key & 0xFFFF | value << 16;
                this.postInsertHook();
                return value;
            } while (cur != key);
        }
        short newValue = (short)((short)(entry >>> 16) + addition);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Short, ? extends Short> m) {
        CommonShortShortMapOps.putAll(this, m);
    }

    @Override
    public Short replace(Short key, Short value) {
        short free;
        short k = key;
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            short oldValue = (short)(entry >>> 16);
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return null;
    }

    @Override
    public short replace(short key, short value) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            short oldValue = (short)(entry >>> 16);
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Short key, Short oldValue, Short newValue) {
        return this.replace((short)key, (short)oldValue, (short)newValue);
    }

    @Override
    public boolean replace(short key, short oldValue, short newValue) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((short)(entry >>> 16) == oldValue) {
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Short, ? super Short, ? extends Short> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.apply((Short)key, (Short)((short)(entry >>> 16))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ShortShortToShortFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.applyAsShort(key, (short)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        int entry;
        short keyToShift;
        int indexToRemove;
        short free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
            if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = entry;
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
        this.postRemoveHook();
    }

    @Override
    public Short remove(Object key) {
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue)) {
            short keyToShift;
            int indexToRemove;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            short val = (short)(entry >>> 16);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(short key) {
        short free = this.freeValue;
        if (key != free) {
            short keyToShift;
            int indexToRemove;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public short remove(short key) {
        short free = this.freeValue;
        if (key != free) {
            short keyToShift;
            int indexToRemove;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            short val = (short)(entry >>> 16);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Short)key, (Short)value);
    }

    public boolean remove(short key, short value) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((short)(entry >>> 16) == value) {
                short keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(ShortShortPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        short delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || !filter.test(key, (short)(entry >>> 16))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    short keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Short> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        short delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || !filter.test((Short)key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    short keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(ShortPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        short delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    short keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashShortSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        short delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    short keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashShortSet thisC, @Nonnull ShortCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        short delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    short keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashShortSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof ShortCollection) {
            return this.retainAll(thisC, (ShortCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        short delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block13: {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    short keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashShortSet thisC, @Nonnull ShortCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        short delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block12: {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    short keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved, short delayedRemoved) {
        short free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            short keyToShift;
            int indexToRemove;
            int entry = tab[i];
            if ((short)entry != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if (keyToShift != delayedRemoved && (LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
        }
    }

    @Override
    public ShortIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public ShortCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements ShortShortCursor {
        int[] tab;
        final short free;
        final int capacityMask;
        int expectedModCount;
        int index;
        short curKey;
        short curValue;

        NoRemovedMapCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVShortShortMapGO.this.freeValue);
        }

        public void forEachForward(ShortShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(key, (short)(entry >>> 16));
            }
            if (index != this.index || mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(short value) {
            if (this.curKey == this.free) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashParallelKVShortShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), value);
            if (this.tab == MutableLHashParallelKVShortShortMapGO.this.table) return;
            UnsafeConstants.U.putShort(MutableLHashParallelKVShortShortMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            short curKey = this.curKey;
            short free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVShortShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVShortShortMapGO.this.table) {
                int entry;
                short keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVShortShortMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        int[] tab;
        final short free;
        final int capacityMask;
        int expectedModCount;
        int index;
        short curKey;
        short curValue;

        NoRemovedValueCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVShortShortMapGO.this.freeValue);
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (index != this.index || mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            short curKey = this.curKey;
            short free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVShortShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVShortShortMapGO.this.table) {
                int entry;
                short keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVShortShortMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        int[] tab;
        final short free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            this.capacityMask = tab.length - 1;
            short free = this.free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((short)entry == free) continue;
                this.next = (short)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    short free = this.free;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        if ((short)entry == free) continue;
                        this.next = (short)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVShortShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVShortShortMapGO.this.table) {
                int entry;
                short keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = (short)(entry >>> 16);
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVShortShortMapGO.this.justRemove(UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)index << 2)));
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, Short>> {
        int[] tab;
        final short free;
        final int capacityMask;
        int expectedModCount;
        int index;
        short curKey;
        short curValue;

        NoRemovedEntryCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVShortShortMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(new MutableEntry2(mc, i, key, (short)(entry >>> 16)));
            }
            if (index != this.index || mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, Short> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            short curKey = this.curKey;
            short free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVShortShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVShortShortMapGO.this.table) {
                int entry;
                short keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVShortShortMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, short key, short value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(short newValue) {
                if (NoRemovedEntryCursor.this.tab == MutableLHashParallelKVShortShortMapGO.this.table) {
                    UnsafeConstants.U.putShort(NoRemovedEntryCursor.this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)NoRemovedEntryCursor.this.index << 2), newValue);
                } else {
                    MutableLHashParallelKVShortShortMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, Short>> {
        int[] tab;
        final short free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            this.capacityMask = tab.length - 1;
            short free = this.free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                short key = (short)entry;
                if (key == free) continue;
                this.next = new MutableEntry2(mc, nextI, key, (short)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(new MutableEntry2(mc, i, key, (short)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    short free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        short key = (short)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry2(mc, nextI, key, (short)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVShortShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVShortShortMapGO.this.table) {
                int entry;
                short keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashParallelKVShortShortMapGO.this.modCount(), indexToShift, keyToShift, (short)(entry >>> 16));
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVShortShortMapGO.this.justRemove(UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)index << 2)));
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, short key, short value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(short newValue) {
                if (NoRemovedEntryIterator.this.tab == MutableLHashParallelKVShortShortMapGO.this.table) {
                    UnsafeConstants.U.putShort(NoRemovedEntryIterator.this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)NoRemovedEntryIterator.this.index << 2), newValue);
                } else {
                    MutableLHashParallelKVShortShortMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableLHashParallelKVShortShortMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashParallelKVShortShortMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableLHashParallelKVShortShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return MutableLHashParallelKVShortShortMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free || predicate.test((short)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free || c.contains((short)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                changed |= c.add((short)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                changed |= s.removeShort((short)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ShortCursor cursor() {
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                result[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                a[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                result[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                a[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                sb.append(' ').append((short)(entry >>> 16)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return MutableLHashParallelKVShortShortMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableLHashParallelKVShortShortMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            short delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    if ((short)entry == free || !filter.test((Short)((short)(entry >>> 16)))) continue;
                    MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        short keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVShortShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(ShortPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            short delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    if ((short)entry == free || !filter.test((short)(entry >>> 16))) continue;
                    MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        short keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVShortShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.removeAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            short delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    int entry = tab[i];
                    if ((short)entry == free || !c.contains((short)(entry >>> 16))) continue;
                    MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        short keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVShortShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            short delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    if ((short)entry == free || !c.contains((short)(entry >>> 16))) continue;
                    MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        short keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVShortShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.retainAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            short delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block13: {
                    int entry = tab[i];
                    if ((short)entry == free || c.contains((short)(entry >>> 16))) continue;
                    MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        short keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVShortShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            short delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    int entry = tab[i];
                    if ((short)entry == free || c.contains((short)(entry >>> 16))) continue;
                    MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        short keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVShortShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ShortShortEntry {
        private short key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(short key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ShortShortEntry {
        int modCount;
        private final int index;
        final short key;
        private short value;

        MutableEntry(int modCount, int index, short key, short value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }

        @Override
        public Short setValue(Short newValue) {
            short unwrappedNewValue;
            if (this.modCount != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            short oldValue = this.value;
            this.value = unwrappedNewValue = newValue.shortValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(short newValue) {
            UnsafeConstants.U.putShort(MutableLHashParallelKVShortShortMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), newValue);
        }
    }

    abstract class ShortShortEntry
    extends AbstractEntry<Short, Short> {
        ShortShortEntry() {
        }

        abstract short key();

        @Override
        public final Short getKey() {
            return this.key();
        }

        abstract short value();

        @Override
        public final Short getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                short k2 = (Short)e2.getKey();
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Short, Short>>
    implements HashObjSet<Map.Entry<Short, Short>>,
    InternalObjCollectionOps<Map.Entry<Short, Short>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Short, Short>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashParallelKVShortShortMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableLHashParallelKVShortShortMapGO.this.size();
        }

        public double currentLoad() {
            return MutableLHashParallelKVShortShortMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashParallelKVShortShortMapGO.this.containsEntry((Short)e.getKey(), (Short)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Short, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (short)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Short, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || predicate.test(new MutableEntry(mc, i, key, (short)(entry >>> 16)))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Short, Short>> iterator() {
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Short, Short>> cursor() {
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || c.contains((Object)e.with(key, (short)(entry >>> 16)))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (short)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Short, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableLHashParallelKVShortShortMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((short)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashParallelKVShortShortMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                short key = (Short)e.getKey();
                short value = (Short)e.getValue();
                return MutableLHashParallelKVShortShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Short, Short>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            short delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || !filter.test(new MutableEntry(mc, i, key, (short)(entry >>> 16)))) continue;
                    MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        short keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVShortShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            short delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block13: {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || !c.contains(e.with(key, (short)(entry >>> 16)))) continue;
                    MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        short keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVShortShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVShortShortMapGO.this.modCount();
            short free = MutableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVShortShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            short delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || c.contains(e.with(key, (short)(entry >>> 16)))) continue;
                    MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        short keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVShortShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableLHashParallelKVShortShortMapGO.this.clear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableParallelKVShortLHashGO.NoRemovedCursor {
        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashParallelKVShortShortMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            short curKey = this.curKey;
            short free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVShortShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVShortShortMapGO.this.table) {
                int entry;
                short keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVShortShortMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableParallelKVShortLHashGO.NoRemovedIterator {
        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashParallelKVShortShortMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVShortShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVShortShortMapGO.this.table) {
                int entry;
                short keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVShortShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (short)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVShortKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                MutableLHashParallelKVShortShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVShortShortMapGO.this.justRemove(UnsafeConstants.U.getShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)index << 2)));
            }
        }
    }
}

