/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import net.openhft.collect.impl.InternalLongDoubleMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableLHashParallelKVLongKeyMap;
import net.openhft.collect.impl.hash.ParallelKVLongDoubleLHash;
import net.openhft.collect.map.hash.HashLongDoubleMap;

public abstract class MutableLHashParallelKVLongDoubleMapSO
extends MutableLHashParallelKVLongKeyMap
implements HashLongDoubleMap,
InternalLongDoubleMapOps,
ParallelKVLongDoubleLHash {
    int valueIndex(long value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            if (tab[i] == free || value != tab[i + 1]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(long value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(long value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(double value) {
        if (this.isEmpty()) {
            return -1;
        }
        long val = Double.doubleToLongBits(value);
        int index = -1;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            if (tab[i] == free || val != tab[i + 1]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(double value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(double value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Double)value);
    }

    int insert(long key, long value) {
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVLongKeyMixing.mix(key) & capacityMask;
        long cur = tab[index];
        if (cur == key) {
            return index;
        }
        if (cur != free) {
            do {
                if ((cur = tab[index = index - 2 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
        }
        this.incrementModCount();
        tab[index] = key;
        tab[index + 1] = value;
        this.postInsertHook();
        return -1;
    }
}

