/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.CharHashFactory;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableLHashSeparateKVCharIntMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.LHashSeparateKVCharIntMapFactorySO;
import net.openhft.collect.impl.hash.MutableLHashSeparateKVCharIntMapGO;
import net.openhft.collect.impl.hash.SeparateKVCharIntLHash;
import net.openhft.collect.impl.hash.UpdatableLHashSeparateKVCharIntMapGO;
import net.openhft.collect.map.hash.HashCharIntMap;
import net.openhft.collect.map.hash.HashCharIntMapFactory;
import net.openhft.function.CharIntConsumer;
import net.openhft.function.Consumer;
import net.openhft.function.Predicate;

public abstract class LHashSeparateKVCharIntMapFactoryGO
extends LHashSeparateKVCharIntMapFactorySO {
    LHashSeparateKVCharIntMapFactoryGO(HashConfig hashConf, int defaultExpectedSize, char lower, char upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashCharIntMapFactory thisWith(HashConfig var1, int var2, char var3, char var4);

    abstract HashCharIntMapFactory lHashLikeThisWith(HashConfig var1, int var2, char var3, char var4);

    abstract HashCharIntMapFactory qHashLikeThisWith(HashConfig var1, int var2, char var3, char var4);

    public final HashCharIntMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashCharIntMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    final HashCharIntMapFactory withDomain(char lower, char upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public final HashCharIntMapFactory withKeysDomain(char lower, char upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public final HashCharIntMapFactory withKeysDomainComplement(char lower, char upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain((char)(upper + '\u0001'), (char)(lower - '\u0001'));
    }

    public String toString() {
        return "HashCharIntMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashCharIntMapFactory) {
            HashCharIntMapFactory factory = (HashCharIntMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((CharHashFactory)factory) && Integer.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public int getDefaultValue() {
        return 0;
    }

    private UpdatableLHashSeparateKVCharIntMapGO shrunk(UpdatableLHashSeparateKVCharIntMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableLHashSeparateKVCharIntMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Map<Character, Integer> map) {
        return this.shrunk((UpdatableLHashSeparateKVCharIntMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Map<Character, Integer> map1, Map<Character, Integer> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4, Map<Character, Integer> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, int expectedSize) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Integer>)map1);
        map.putAll((Map<? extends Character, ? extends Integer>)map2);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Integer>)map1);
        map.putAll((Map<? extends Character, ? extends Integer>)map2);
        map.putAll((Map<? extends Character, ? extends Integer>)map3);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4, int expectedSize) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Integer>)map1);
        map.putAll((Map<? extends Character, ? extends Integer>)map2);
        map.putAll((Map<? extends Character, ? extends Integer>)map3);
        map.putAll((Map<? extends Character, ? extends Integer>)map4);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Integer>)map1);
        map.putAll((Map<? extends Character, ? extends Integer>)map2);
        map.putAll((Map<? extends Character, ? extends Integer>)map3);
        map.putAll((Map<? extends Character, ? extends Integer>)map4);
        map.putAll((Map<? extends Character, ? extends Integer>)map5);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Consumer<CharIntConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Consumer<CharIntConsumer> entriesSupplier, int expectedSize) {
        final UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new CharIntConsumer(){

            public void accept(char k, int v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(char[] keys, int[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(char[] keys, int[] values, int expectedSize) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Character[] keys, Integer[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Character[] keys, Integer[] values, int expectedSize) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Iterable<Character> keys, Iterable<Integer> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMap(Iterable<Character> keys, Iterable<Integer> values, int expectedSize) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Character> keysIt = keys.iterator();
        Iterator<Integer> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMapOf(char k1, int v1) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMapOf(char k1, int v1, char k2, int v2) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMapOf(char k1, int v1, char k2, int v2, char k3, int v3) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMapOf(char k1, int v1, char k2, int v2, char k3, int v3, char k4, int v4) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableLHashSeparateKVCharIntMapGO newUpdatableMapOf(char k1, int v1, char k2, int v2, char k3, int v3, char k4, int v4, char k5, int v5) {
        UpdatableLHashSeparateKVCharIntMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashCharIntMap newMutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, int expectedSize) {
        MutableLHashSeparateKVCharIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashCharIntMap newMutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize) {
        MutableLHashSeparateKVCharIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashCharIntMap newMutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4, int expectedSize) {
        MutableLHashSeparateKVCharIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashCharIntMap newMutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize) {
        MutableLHashSeparateKVCharIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashCharIntMap newMutableMap(Map<Character, Integer> map) {
        MutableLHashSeparateKVCharIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashCharIntMap newMutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2) {
        MutableLHashSeparateKVCharIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashCharIntMap newMutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3) {
        MutableLHashSeparateKVCharIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashCharIntMap newMutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4) {
        MutableLHashSeparateKVCharIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashCharIntMap newMutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4, Map<Character, Integer> map5) {
        MutableLHashSeparateKVCharIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashCharIntMap newMutableMap(Consumer<CharIntConsumer> entriesSupplier) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVCharIntLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashCharIntMap newMutableMap(Consumer<CharIntConsumer> entriesSupplier, int expectedSize) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVCharIntLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashCharIntMap newMutableMap(char[] keys, int[] values) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharIntMap newMutableMap(char[] keys, int[] values, int expectedSize) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharIntMap newMutableMap(Character[] keys, Integer[] values) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharIntMap newMutableMap(Character[] keys, Integer[] values, int expectedSize) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharIntMap newMutableMap(Iterable<Character> keys, Iterable<Integer> values) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVCharIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashCharIntMap newMutableMap(Iterable<Character> keys, Iterable<Integer> values, int expectedSize) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVCharIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashCharIntMap newMutableMapOf(char k1, int v1) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashCharIntMap newMutableMapOf(char k1, int v1, char k2, int v2) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashCharIntMap newMutableMapOf(char k1, int v1, char k2, int v2, char k3, int v3) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashCharIntMap newMutableMapOf(char k1, int v1, char k2, int v2, char k3, int v3, char k4, int v4) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashCharIntMap newMutableMapOf(char k1, int v1, char k2, int v2, char k3, int v3, char k4, int v4, char k5, int v5) {
        MutableLHashSeparateKVCharIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashCharIntMap newImmutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, int expectedSize) {
        ImmutableLHashSeparateKVCharIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashCharIntMap newImmutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize) {
        ImmutableLHashSeparateKVCharIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashCharIntMap newImmutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4, int expectedSize) {
        ImmutableLHashSeparateKVCharIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashCharIntMap newImmutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize) {
        ImmutableLHashSeparateKVCharIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashCharIntMap newImmutableMap(Map<Character, Integer> map) {
        ImmutableLHashSeparateKVCharIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashCharIntMap newImmutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2) {
        ImmutableLHashSeparateKVCharIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashCharIntMap newImmutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3) {
        ImmutableLHashSeparateKVCharIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashCharIntMap newImmutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4) {
        ImmutableLHashSeparateKVCharIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashCharIntMap newImmutableMap(Map<Character, Integer> map1, Map<Character, Integer> map2, Map<Character, Integer> map3, Map<Character, Integer> map4, Map<Character, Integer> map5) {
        ImmutableLHashSeparateKVCharIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashCharIntMap newImmutableMap(Consumer<CharIntConsumer> entriesSupplier) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVCharIntLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashCharIntMap newImmutableMap(Consumer<CharIntConsumer> entriesSupplier, int expectedSize) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVCharIntLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashCharIntMap newImmutableMap(char[] keys, int[] values) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharIntMap newImmutableMap(char[] keys, int[] values, int expectedSize) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharIntMap newImmutableMap(Character[] keys, Integer[] values) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharIntMap newImmutableMap(Character[] keys, Integer[] values, int expectedSize) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharIntMap newImmutableMap(Iterable<Character> keys, Iterable<Integer> values) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVCharIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashCharIntMap newImmutableMap(Iterable<Character> keys, Iterable<Integer> values, int expectedSize) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVCharIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashCharIntMap newImmutableMapOf(char k1, int v1) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashCharIntMap newImmutableMapOf(char k1, int v1, char k2, int v2) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashCharIntMap newImmutableMapOf(char k1, int v1, char k2, int v2, char k3, int v3) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashCharIntMap newImmutableMapOf(char k1, int v1, char k2, int v2, char k3, int v3, char k4, int v4) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashCharIntMap newImmutableMapOf(char k1, int v1, char k2, int v2, char k3, int v3, char k4, int v4, char k5, int v5) {
        ImmutableLHashSeparateKVCharIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

