/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.CharHashFactory;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableLHashParallelKVCharCharMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.LHashParallelKVCharCharMapFactorySO;
import net.openhft.collect.impl.hash.MutableLHashParallelKVCharCharMapGO;
import net.openhft.collect.impl.hash.ParallelKVCharCharLHash;
import net.openhft.collect.impl.hash.UpdatableLHashParallelKVCharCharMapGO;
import net.openhft.collect.map.hash.HashCharCharMap;
import net.openhft.collect.map.hash.HashCharCharMapFactory;
import net.openhft.function.CharCharConsumer;
import net.openhft.function.Consumer;
import net.openhft.function.Predicate;

public abstract class LHashParallelKVCharCharMapFactoryGO
extends LHashParallelKVCharCharMapFactorySO {
    LHashParallelKVCharCharMapFactoryGO(HashConfig hashConf, int defaultExpectedSize, char lower, char upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashCharCharMapFactory thisWith(HashConfig var1, int var2, char var3, char var4);

    abstract HashCharCharMapFactory lHashLikeThisWith(HashConfig var1, int var2, char var3, char var4);

    abstract HashCharCharMapFactory qHashLikeThisWith(HashConfig var1, int var2, char var3, char var4);

    public final HashCharCharMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashCharCharMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    final HashCharCharMapFactory withDomain(char lower, char upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public final HashCharCharMapFactory withKeysDomain(char lower, char upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public final HashCharCharMapFactory withKeysDomainComplement(char lower, char upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain((char)(upper + '\u0001'), (char)(lower - '\u0001'));
    }

    public String toString() {
        return "HashCharCharMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashCharCharMapFactory) {
            HashCharCharMapFactory factory = (HashCharCharMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((CharHashFactory)factory) && Character.valueOf(this.getDefaultValue()).equals(Character.valueOf(factory.getDefaultValue()));
        }
        return false;
    }

    public char getDefaultValue() {
        return '\u0000';
    }

    private UpdatableLHashParallelKVCharCharMapGO shrunk(UpdatableLHashParallelKVCharCharMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableLHashParallelKVCharCharMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Map<Character, Character> map) {
        return this.shrunk((UpdatableLHashParallelKVCharCharMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Map<Character, Character> map1, Map<Character, Character> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4, Map<Character, Character> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Map<Character, Character> map1, Map<Character, Character> map2, int expectedSize) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Character>)map1);
        map.putAll((Map<? extends Character, ? extends Character>)map2);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Character>)map1);
        map.putAll((Map<? extends Character, ? extends Character>)map2);
        map.putAll((Map<? extends Character, ? extends Character>)map3);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4, int expectedSize) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Character>)map1);
        map.putAll((Map<? extends Character, ? extends Character>)map2);
        map.putAll((Map<? extends Character, ? extends Character>)map3);
        map.putAll((Map<? extends Character, ? extends Character>)map4);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Character>)map1);
        map.putAll((Map<? extends Character, ? extends Character>)map2);
        map.putAll((Map<? extends Character, ? extends Character>)map3);
        map.putAll((Map<? extends Character, ? extends Character>)map4);
        map.putAll((Map<? extends Character, ? extends Character>)map5);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Consumer<CharCharConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Consumer<CharCharConsumer> entriesSupplier, int expectedSize) {
        final UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new CharCharConsumer(){

            public void accept(char k, char v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(char[] keys, char[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(char[] keys, char[] values, int expectedSize) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Character[] keys, Character[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Character[] keys, Character[] values, int expectedSize) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Iterable<Character> keys, Iterable<Character> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMap(Iterable<Character> keys, Iterable<Character> values, int expectedSize) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Character> keysIt = keys.iterator();
        Iterator<Character> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMapOf(char k1, char v1) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMapOf(char k1, char v1, char k2, char v2) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMapOf(char k1, char v1, char k2, char v2, char k3, char v3) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMapOf(char k1, char v1, char k2, char v2, char k3, char v3, char k4, char v4) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableLHashParallelKVCharCharMapGO newUpdatableMapOf(char k1, char v1, char k2, char v2, char k3, char v3, char k4, char v4, char k5, char v5) {
        UpdatableLHashParallelKVCharCharMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashCharCharMap newMutableMap(Map<Character, Character> map1, Map<Character, Character> map2, int expectedSize) {
        MutableLHashParallelKVCharCharMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashCharCharMap newMutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize) {
        MutableLHashParallelKVCharCharMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashCharCharMap newMutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4, int expectedSize) {
        MutableLHashParallelKVCharCharMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashCharCharMap newMutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize) {
        MutableLHashParallelKVCharCharMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashCharCharMap newMutableMap(Map<Character, Character> map) {
        MutableLHashParallelKVCharCharMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashCharCharMap newMutableMap(Map<Character, Character> map1, Map<Character, Character> map2) {
        MutableLHashParallelKVCharCharMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashCharCharMap newMutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3) {
        MutableLHashParallelKVCharCharMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashCharCharMap newMutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4) {
        MutableLHashParallelKVCharCharMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashCharCharMap newMutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4, Map<Character, Character> map5) {
        MutableLHashParallelKVCharCharMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashCharCharMap newMutableMap(Consumer<CharCharConsumer> entriesSupplier) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVCharCharLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashCharCharMap newMutableMap(Consumer<CharCharConsumer> entriesSupplier, int expectedSize) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVCharCharLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashCharCharMap newMutableMap(char[] keys, char[] values) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharCharMap newMutableMap(char[] keys, char[] values, int expectedSize) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharCharMap newMutableMap(Character[] keys, Character[] values) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharCharMap newMutableMap(Character[] keys, Character[] values, int expectedSize) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharCharMap newMutableMap(Iterable<Character> keys, Iterable<Character> values) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVCharCharLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashCharCharMap newMutableMap(Iterable<Character> keys, Iterable<Character> values, int expectedSize) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVCharCharLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashCharCharMap newMutableMapOf(char k1, char v1) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashCharCharMap newMutableMapOf(char k1, char v1, char k2, char v2) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashCharCharMap newMutableMapOf(char k1, char v1, char k2, char v2, char k3, char v3) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashCharCharMap newMutableMapOf(char k1, char v1, char k2, char v2, char k3, char v3, char k4, char v4) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashCharCharMap newMutableMapOf(char k1, char v1, char k2, char v2, char k3, char v3, char k4, char v4, char k5, char v5) {
        MutableLHashParallelKVCharCharMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashCharCharMap newImmutableMap(Map<Character, Character> map1, Map<Character, Character> map2, int expectedSize) {
        ImmutableLHashParallelKVCharCharMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashCharCharMap newImmutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize) {
        ImmutableLHashParallelKVCharCharMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashCharCharMap newImmutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4, int expectedSize) {
        ImmutableLHashParallelKVCharCharMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashCharCharMap newImmutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize) {
        ImmutableLHashParallelKVCharCharMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashCharCharMap newImmutableMap(Map<Character, Character> map) {
        ImmutableLHashParallelKVCharCharMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashCharCharMap newImmutableMap(Map<Character, Character> map1, Map<Character, Character> map2) {
        ImmutableLHashParallelKVCharCharMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashCharCharMap newImmutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3) {
        ImmutableLHashParallelKVCharCharMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashCharCharMap newImmutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4) {
        ImmutableLHashParallelKVCharCharMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashCharCharMap newImmutableMap(Map<Character, Character> map1, Map<Character, Character> map2, Map<Character, Character> map3, Map<Character, Character> map4, Map<Character, Character> map5) {
        ImmutableLHashParallelKVCharCharMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVCharCharLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashCharCharMap newImmutableMap(Consumer<CharCharConsumer> entriesSupplier) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVCharCharLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashCharCharMap newImmutableMap(Consumer<CharCharConsumer> entriesSupplier, int expectedSize) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVCharCharLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashCharCharMap newImmutableMap(char[] keys, char[] values) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharCharMap newImmutableMap(char[] keys, char[] values, int expectedSize) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharCharMap newImmutableMap(Character[] keys, Character[] values) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharCharMap newImmutableMap(Character[] keys, Character[] values, int expectedSize) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharCharMap newImmutableMap(Iterable<Character> keys, Iterable<Character> values) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVCharCharLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashCharCharMap newImmutableMap(Iterable<Character> keys, Iterable<Character> values, int expectedSize) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVCharCharLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashCharCharMap newImmutableMapOf(char k1, char v1) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashCharCharMap newImmutableMapOf(char k1, char v1, char k2, char v2) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashCharCharMap newImmutableMapOf(char k1, char v1, char k2, char v2, char k3, char v3) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashCharCharMap newImmutableMapOf(char k1, char v1, char k2, char v2, char k3, char v3, char k4, char v4) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashCharCharMap newImmutableMapOf(char k1, char v1, char k2, char v2, char k3, char v3, char k4, char v4, char k5, char v5) {
        ImmutableLHashParallelKVCharCharMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

