/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.ImmutableLHashObjSet;
import net.openhft.collect.impl.hash.ImmutableLHashObjSetGO;
import net.openhft.collect.impl.hash.LHashObjSetFactoryGO;
import net.openhft.collect.impl.hash.MutableLHashObjSet;
import net.openhft.collect.impl.hash.MutableLHashObjSetGO;
import net.openhft.collect.impl.hash.QHashObjSetFactoryImpl;
import net.openhft.collect.impl.hash.UpdatableLHashObjSet;
import net.openhft.collect.impl.hash.UpdatableLHashObjSetGO;
import net.openhft.collect.set.hash.HashObjSetFactory;

public final class LHashObjSetFactoryImpl<E>
extends LHashObjSetFactoryGO<E> {
    public LHashObjSetFactoryImpl() {
        this(HashConfig.getDefault(), 10, false);
    }

    public LHashObjSetFactoryImpl(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        super(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    public <E2> HashObjSetFactory<E2> withEquivalence(@Nullable Equivalence<E2> equivalence) {
        if (equivalence == null) {
            return this;
        }
        return new WithCustomEquivalence<E2>(this.getHashConfig(), this.getDefaultExpectedSize(), this.isNullKeyAllowed(), equivalence);
    }

    public HashObjSetFactory<E> withNullKeyAllowed(boolean nullAllowed) {
        if (nullAllowed == this.isNullKeyAllowed()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), nullAllowed);
    }

    @Override
    HashObjSetFactory<E> thisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new LHashObjSetFactoryImpl<E>(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    @Override
    HashObjSetFactory<E> qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new QHashObjSetFactoryImpl(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    @Override
    HashObjSetFactory<E> lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new LHashObjSetFactoryImpl<E>(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    static final class WithCustomEquivalence<E>
    extends LHashObjSetFactoryGO<E> {
        final Equivalence<E> equivalence;

        public WithCustomEquivalence(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed, Equivalence<E> equivalence) {
            super(hashConf, defaultExpectedSize, isNullKeyAllowed);
            this.equivalence = equivalence;
        }

        @Override
        public Equivalence<E> getEquivalence() {
            return this.equivalence;
        }

        @Override
        <E2 extends E> MutableLHashObjSetGO<E2> uninitializedMutableSet() {
            MutableLHashObjSet.WithCustomEquivalence set = new MutableLHashObjSet.WithCustomEquivalence();
            set.equivalence = this.equivalence;
            return set;
        }

        @Override
        <E2 extends E> UpdatableLHashObjSetGO<E2> uninitializedUpdatableSet() {
            UpdatableLHashObjSet.WithCustomEquivalence set = new UpdatableLHashObjSet.WithCustomEquivalence();
            set.equivalence = this.equivalence;
            return set;
        }

        @Override
        <E2 extends E> ImmutableLHashObjSetGO<E2> uninitializedImmutableSet() {
            ImmutableLHashObjSet.WithCustomEquivalence set = new ImmutableLHashObjSet.WithCustomEquivalence();
            set.equivalence = this.equivalence;
            return set;
        }

        public <E2> HashObjSetFactory<E2> withEquivalence(@Nullable Equivalence<E2> equivalence) {
            if (equivalence == null) {
                return new LHashObjSetFactoryImpl(this.getHashConfig(), this.getDefaultExpectedSize(), this.isNullKeyAllowed());
            }
            if (this.equivalence.equals(equivalence)) {
                return this;
            }
            return new WithCustomEquivalence<E2>(this.getHashConfig(), this.getDefaultExpectedSize(), this.isNullKeyAllowed(), equivalence);
        }

        public HashObjSetFactory<E> withNullKeyAllowed(boolean nullAllowed) {
            if (nullAllowed == this.isNullKeyAllowed()) {
                return this;
            }
            return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), nullAllowed);
        }

        @Override
        HashObjSetFactory<E> thisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new WithCustomEquivalence<E>(hashConf, defaultExpectedSize, isNullKeyAllowed, this.equivalence);
        }

        @Override
        HashObjSetFactory<E> qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new QHashObjSetFactoryImpl.WithCustomEquivalence<E>(hashConf, defaultExpectedSize, isNullKeyAllowed, this.equivalence);
        }

        @Override
        HashObjSetFactory<E> lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new WithCustomEquivalence<E>(hashConf, defaultExpectedSize, isNullKeyAllowed, this.equivalence);
        }
    }
}

