/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.IntCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.ImmutableLHashIntSet;
import net.openhft.collect.impl.hash.ImmutableLHashIntSetGO;
import net.openhft.collect.impl.hash.IntLHashFactory;
import net.openhft.collect.impl.hash.MutableLHashIntSet;
import net.openhft.collect.impl.hash.MutableLHashIntSetGO;
import net.openhft.collect.impl.hash.SeparateKVIntLHash;
import net.openhft.collect.impl.hash.UpdatableLHashIntSet;
import net.openhft.collect.impl.hash.UpdatableLHashIntSetGO;
import net.openhft.collect.set.hash.HashIntSetFactory;

public abstract class LHashIntSetFactorySO
extends IntLHashFactory
implements HashIntSetFactory {
    LHashIntSetFactorySO(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    MutableLHashIntSetGO uninitializedMutableSet() {
        return new MutableLHashIntSet();
    }

    UpdatableLHashIntSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashIntSet();
    }

    ImmutableLHashIntSetGO uninitializedImmutableSet() {
        return new ImmutableLHashIntSet();
    }

    public MutableLHashIntSetGO newMutableSet(int expectedSize) {
        MutableLHashIntSet set = new MutableLHashIntSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableLHashIntSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashIntSet set = new UpdatableLHashIntSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableLHashIntSetGO newUpdatableSet(Iterable<Integer> elements, int expectedSize) {
        if (elements instanceof IntCollection) {
            SeparateKVIntLHash hash;
            if (elements instanceof SeparateKVIntLHash && (hash = (SeparateKVIntLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashIntSet set = new UpdatableLHashIntSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashIntSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashIntSetGO set = this.newUpdatableSet(size);
        for (int e : elements) {
            set.add(e);
        }
        return set;
    }
}

