/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.DoubleCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.DoubleLHashFactory;
import net.openhft.collect.impl.hash.ImmutableLHashDoubleSet;
import net.openhft.collect.impl.hash.ImmutableLHashDoubleSetGO;
import net.openhft.collect.impl.hash.MutableLHashDoubleSet;
import net.openhft.collect.impl.hash.MutableLHashDoubleSetGO;
import net.openhft.collect.impl.hash.SeparateKVDoubleLHash;
import net.openhft.collect.impl.hash.UpdatableLHashDoubleSet;
import net.openhft.collect.impl.hash.UpdatableLHashDoubleSetGO;
import net.openhft.collect.set.hash.HashDoubleSetFactory;

public abstract class LHashDoubleSetFactorySO
extends DoubleLHashFactory
implements HashDoubleSetFactory {
    LHashDoubleSetFactorySO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    MutableLHashDoubleSetGO uninitializedMutableSet() {
        return new MutableLHashDoubleSet();
    }

    UpdatableLHashDoubleSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashDoubleSet();
    }

    ImmutableLHashDoubleSetGO uninitializedImmutableSet() {
        return new ImmutableLHashDoubleSet();
    }

    public MutableLHashDoubleSetGO newMutableSet(int expectedSize) {
        MutableLHashDoubleSet set = new MutableLHashDoubleSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashDoubleSet set = new UpdatableLHashDoubleSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elements, int expectedSize) {
        if (elements instanceof DoubleCollection) {
            SeparateKVDoubleLHash hash;
            if (elements instanceof SeparateKVDoubleLHash && (hash = (SeparateKVDoubleLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashDoubleSet set = new UpdatableLHashDoubleSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashDoubleSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(size);
        for (double e : elements) {
            set.add(e);
        }
        return set;
    }
}

