/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.ByteCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.ByteLHashFactory;
import net.openhft.collect.impl.hash.ImmutableLHashByteSet;
import net.openhft.collect.impl.hash.ImmutableLHashByteSetGO;
import net.openhft.collect.impl.hash.MutableLHashByteSet;
import net.openhft.collect.impl.hash.MutableLHashByteSetGO;
import net.openhft.collect.impl.hash.SeparateKVByteLHash;
import net.openhft.collect.impl.hash.UpdatableLHashByteSet;
import net.openhft.collect.impl.hash.UpdatableLHashByteSetGO;
import net.openhft.collect.set.hash.HashByteSetFactory;

public abstract class LHashByteSetFactorySO
extends ByteLHashFactory
implements HashByteSetFactory {
    LHashByteSetFactorySO(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    MutableLHashByteSetGO uninitializedMutableSet() {
        return new MutableLHashByteSet();
    }

    UpdatableLHashByteSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashByteSet();
    }

    ImmutableLHashByteSetGO uninitializedImmutableSet() {
        return new ImmutableLHashByteSet();
    }

    public MutableLHashByteSetGO newMutableSet(int expectedSize) {
        MutableLHashByteSet set = new MutableLHashByteSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableLHashByteSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashByteSet set = new UpdatableLHashByteSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableLHashByteSetGO newUpdatableSet(Iterable<Byte> elements, int expectedSize) {
        if (elements instanceof ByteCollection) {
            SeparateKVByteLHash hash;
            if (elements instanceof SeparateKVByteLHash && (hash = (SeparateKVByteLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashByteSet set = new UpdatableLHashByteSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashByteSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashByteSetGO set = this.newUpdatableSet(size);
        for (byte e : elements) {
            set.add(e);
        }
        return set;
    }
}

