/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.impl.hash.ImmutableQHash;
import net.openhft.collect.impl.hash.ParallelKVObjQHash;
import net.openhft.collect.impl.hash.QHash;

public abstract class ImmutableParallelKVObjQHashSO<E>
extends ImmutableQHash
implements ParallelKVObjQHash,
QHash {
    Object[] table;

    void copy(ParallelKVObjQHash hash) {
        super.copy(hash);
        this.table = (Object[])hash.table().clone();
    }

    void move(ParallelKVObjQHash hash) {
        super.copy(hash);
        this.table = hash.table();
    }

    boolean nullableKeyEquals(@Nullable E a, @Nullable E b) {
        return a == b || a != null && a.equals(b);
    }

    boolean keyEquals(@Nonnull E a, @Nullable E b) {
        return a.equals(b);
    }

    int nullableKeyHashCode(@Nullable E key) {
        return key != null ? key.hashCode() : 0;
    }

    int keyHashCode(@Nonnull E key) {
        return key.hashCode();
    }

    public boolean contains(@Nullable Object key) {
        return this.index(key) >= 0;
    }

    int index(@Nullable Object key) {
        if (key != null) {
            Object k = key;
            Object[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
            Object cur = tab[index];
            if (cur == k) {
                return index;
            }
            if (cur == FREE) {
                return -1;
            }
            if (this.keyEquals(k, cur)) {
                return index;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 2;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = tab[bIndex]) == k) {
                    return bIndex;
                }
                if (cur == FREE) {
                    return -1;
                }
                if (this.keyEquals(k, cur)) {
                    return bIndex;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = tab[fIndex]) == k) {
                    return fIndex;
                }
                if (cur == FREE) {
                    return -1;
                }
                if (this.keyEquals(k, cur)) {
                    return fIndex;
                }
                step += 4;
            }
        }
        return this.indexNullKey();
    }

    int indexNullKey() {
        Object[] tab = this.table;
        int capacity = tab.length;
        int index = 0;
        Object cur = tab[0];
        if (cur == null) {
            return index;
        }
        if (cur == FREE) {
            return -1;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 2;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = tab[bIndex]) == null) {
                return bIndex;
            }
            if (cur == FREE) {
                return -1;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = tab[fIndex]) == null) {
                return fIndex;
            }
            if (cur == FREE) {
                return -1;
            }
            step += 4;
        }
    }
}

