/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.HashConfigWrapper;
import net.openhft.collect.impl.hash.ImmutableLHash;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.ParallelKVLongLHash;

public abstract class ImmutableParallelKVLongLHashSO
extends ImmutableLHash
implements ParallelKVLongLHash,
PrimitiveConstants,
UnsafeConstants {
    long freeValue;
    long[] table;

    void copy(ParallelKVLongLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = (long[])hash.table().clone();
    }

    void move(ParallelKVLongLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = hash.table();
    }

    final void init(HashConfigWrapper configWrapper, int size, long freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public long freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public long removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Long)key);
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 2;
            int index = LHash.ParallelKVLongKeyMixing.mix(key) & capacityMask;
            long cur = tab[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = tab[index = index - 2 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }
}

