/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.ImmutableLHash;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.ParallelKVFloatLHash;

public abstract class ImmutableParallelKVFloatLHashSO
extends ImmutableLHash
implements ParallelKVFloatLHash,
PrimitiveConstants,
UnsafeConstants {
    long[] table;

    void copy(ParallelKVFloatLHash hash) {
        super.copy(hash);
        this.table = (long[])hash.table().clone();
    }

    void move(ParallelKVFloatLHash hash) {
        super.copy(hash);
        this.table = hash.table();
    }

    public boolean contains(Object key) {
        return this.contains(((Float)key).floatValue());
    }

    public boolean contains(float key) {
        return this.index(Float.floatToIntBits(key)) >= 0;
    }

    public boolean contains(int key) {
        return this.index(key) >= 0;
    }

    int index(int key) {
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(key) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return index;
        }
        if (cur == 0x7FFFFFFE) {
            return -1;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
            return index;
        } while (cur != 0x7FFFFFFE);
        return -1;
    }
}

