/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.ImmutableLHash;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.ParallelKVDoubleLHash;

public abstract class ImmutableParallelKVDoubleLHashSO
extends ImmutableLHash
implements ParallelKVDoubleLHash,
PrimitiveConstants,
UnsafeConstants {
    long[] table;

    void copy(ParallelKVDoubleLHash hash) {
        super.copy(hash);
        this.table = (long[])hash.table().clone();
    }

    void move(ParallelKVDoubleLHash hash) {
        super.copy(hash);
        this.table = hash.table();
    }

    public boolean contains(Object key) {
        return this.contains((Double)key);
    }

    public boolean contains(double key) {
        return this.index(Double.doubleToLongBits(key)) >= 0;
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix(key) & capacityMask;
        long cur = tab[index];
        if (cur == key) {
            return index;
        }
        if (cur == 0x7FFFFFFFFFFFFFFEL) {
            return -1;
        }
        do {
            if ((cur = tab[index = index - 2 & capacityMask]) != key) continue;
            return index;
        } while (cur != 0x7FFFFFFFFFFFFFFEL);
        return -1;
    }
}

