/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.LongCollection;
import net.openhft.collect.LongCursor;
import net.openhft.collect.LongIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractLongValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonShortLongMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.InternalShortLongMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableLHashSeparateKVShortLongMapSO;
import net.openhft.collect.impl.hash.SeparateKVShortLongLHash;
import net.openhft.collect.map.ShortLongCursor;
import net.openhft.collect.set.LongSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.ShortLongConsumer;
import net.openhft.function.ShortLongPredicate;
import net.openhft.function.ShortLongToLongFunction;
import net.openhft.function.ShortToLongFunction;

public class ImmutableLHashSeparateKVShortLongMapGO
extends ImmutableLHashSeparateKVShortLongMapSO {
    @Override
    final void copy(SeparateKVShortLongLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVShortLongLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public long defaultValue() {
        return 0L;
    }

    @Override
    public boolean containsEntry(short key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public long get(short key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Long getOrDefault(Object key, Long defaultValue) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public long getOrDefault(short key, long defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Short, ? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept((Short)key, (Long)vals[i]);
        }
    }

    public void forEach(ShortLongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(ShortLongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ShortLongCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonShortLongMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalShortLongMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalShortLongMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Short, Long>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public LongCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            long val = vals[i];
            hashCode += key ^ (int)(val ^ val >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        short free = this.freeValue;
        short[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Long put(Short key, Long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long put(short key, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long putIfAbsent(Short key, Long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long putIfAbsent(short key, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(short key, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long compute(Short key, BiFunction<? super Short, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long compute(short key, ShortLongToLongFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long computeIfAbsent(Short key, Function<? super Short, ? extends Long> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long computeIfAbsent(short key, ShortToLongFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long computeIfPresent(Short key, BiFunction<? super Short, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long computeIfPresent(short key, ShortLongToLongFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long merge(Short key, Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long merge(short key, long value, LongBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long addValue(short key, long value) {
        throw new UnsupportedOperationException();
    }

    public long addValue(short key, long addition, long defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Short, ? extends Long> m) {
        CommonShortLongMapOps.putAll(this, m);
    }

    @Override
    public Long replace(Short key, Long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long replace(short key, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Short key, Long oldValue, Long newValue) {
        return this.replace((short)key, (long)oldValue, (long)newValue);
    }

    @Override
    public boolean replace(short key, long oldValue, long newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Short, ? super Long, ? extends Long> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ShortLongToLongFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(short key) {
        throw new UnsupportedOperationException();
    }

    public long remove(short key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Short)key, (Long)value);
    }

    public boolean remove(short key, long value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ShortLongPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ShortLongCursor {
        final short[] keys;
        final long[] vals;
        final short free;
        int index;
        short curKey;
        long curValue;

        NoRemovedMapCursor() {
            short free;
            this.keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue);
        }

        public void forEachForward(ShortLongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements LongCursor {
        final short[] keys;
        final long[] vals;
        final short free;
        int index;
        short curKey;
        long curValue;

        NoRemovedValueCursor() {
            short free;
            this.keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue);
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements LongIterator {
        final short[] keys;
        final long[] vals;
        final short free;
        int nextIndex;
        long next;

        NoRemovedValueIterator() {
            this.keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            short free = this.free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                short[] keys = this.keys;
                short free = this.free;
                long prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Long)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, Long>> {
        final short[] keys;
        final long[] vals;
        final short free;
        int index;
        short curKey;
        long curValue;

        NoRemovedEntryCursor() {
            short free;
            this.keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, Long> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, Long>> {
        final short[] keys;
        final long[] vals;
        final short free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            short free = this.free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                short key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            long[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                short[] keys = this.keys;
                short free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    short key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractLongValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVShortLongMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVShortLongMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableLHashSeparateKVShortLongMapGO.this.containsValue(o);
        }

        public boolean contains(long v) {
            return ImmutableLHashSeparateKVShortLongMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Long)vals[i]);
            }
        }

        public void forEach(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(LongPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(LongCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(LongCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(LongSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeLong(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public LongIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public LongCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public long[] toLongArray() {
            int size = this.size();
            long[] result = new long[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public long[] toArray(long[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new long[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0L;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0L;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeLong((Long)o);
        }

        public boolean removeLong(long v) {
            return ImmutableLHashSeparateKVShortLongMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVShortLongMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(LongPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ShortLongEntry {
        private short key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(short key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ShortLongEntry {
        private final short key;
        private final long value;

        ImmutableEntry(short key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    abstract class ShortLongEntry
    extends AbstractEntry<Short, Long> {
        ShortLongEntry() {
        }

        abstract short key();

        @Override
        public final Short getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Long getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                short k2 = (Short)e2.getKey();
                long v2 = (Long)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Short, Long>>
    implements HashObjSet<Map.Entry<Short, Long>>,
    InternalObjCollectionOps<Map.Entry<Short, Long>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Short, Long>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashSeparateKVShortLongMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVShortLongMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableLHashSeparateKVShortLongMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashSeparateKVShortLongMapGO.this.containsEntry((Short)e.getKey(), (Long)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Short, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Short, Long>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || predicate.test(new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Short, Long>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Short, Long>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Short, Long>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableLHashSeparateKVShortLongMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            short free = ImmutableLHashSeparateKVShortLongMapGO.this.freeValue;
            short[] keys = ImmutableLHashSeparateKVShortLongMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVShortLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVShortLongMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                short key = (Short)e.getKey();
                long value = (Long)e.getValue();
                return ImmutableLHashSeparateKVShortLongMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Short, Long>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVShortLongMapGO.this.clear();
        }
    }
}

